/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette;

import java.util.function.Consumer;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.components.palette.Palette;
import org.kie.workbench.common.stunner.core.client.components.palette.PaletteDefinition;
import org.kie.workbench.common.stunner.core.client.components.palette.PaletteItemEvent;
import org.kie.workbench.common.stunner.core.client.components.palette.PaletteItemMouseEvent;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.uberfire.mvp.Command;

public abstract class AbstractPalette<D extends PaletteDefinition>
implements Palette<D> {
    protected final ShapeManager shapeManager;
    protected Command closeCallback;
    protected Consumer<PaletteItemMouseEvent> itemHoverCallback;
    protected Consumer<PaletteItemEvent> itemOutCallback;
    protected Consumer<PaletteItemMouseEvent> itemMouseDownCallback;
    protected Consumer<PaletteItemMouseEvent> itemClickCallback;
    protected D paletteDefinition;

    protected AbstractPalette() {
        this(null);
    }

    protected AbstractPalette(ShapeManager shapeManager) {
        this.shapeManager = shapeManager;
    }

    protected abstract AbstractPalette<D> bind();

    protected abstract void doDestroy();

    protected abstract String getPaletteItemId(int var1);

    public AbstractPalette<D> bind(D paletteDefinition) {
        this.paletteDefinition = paletteDefinition;
        this.beforeBind();
        this.bind();
        this.afterBind();
        return this;
    }

    protected void beforeBind() {
    }

    protected void afterBind() {
    }

    public AbstractPalette<D> onClose(Command callback) {
        this.closeCallback = callback;
        return this;
    }

    public AbstractPalette<D> onItemHover(Consumer<PaletteItemMouseEvent> callback) {
        this.itemHoverCallback = callback;
        return this;
    }

    public AbstractPalette<D> onItemOut(Consumer<PaletteItemEvent> callback) {
        this.itemOutCallback = callback;
        return this;
    }

    public AbstractPalette<D> onItemMouseDown(Consumer<PaletteItemMouseEvent> callback) {
        this.itemMouseDownCallback = callback;
        return this;
    }

    public AbstractPalette<D> onItemClick(Consumer<PaletteItemMouseEvent> callback) {
        this.itemClickCallback = callback;
        return this;
    }

    public boolean onClose() {
        this.doClose();
        if (null != this.closeCallback) {
            this.closeCallback.execute();
        }
        return true;
    }

    protected void doClose() {
    }

    public boolean onItemHover(int index, double mouseX, double mouseY, double itemX, double itemY) {
        String id = this.getPaletteItemId(index);
        this.doItemHover(id, mouseX, mouseY, itemX, itemY);
        if (null != this.itemHoverCallback) {
            this.itemHoverCallback.accept(new PaletteItemMouseEvent(this.getPaletteItemId(index), mouseX, mouseY, itemX, itemY));
        }
        return true;
    }

    protected void doItemHover(String id, double mouseX, double mouseY, double itemX, double itemY) {
    }

    public boolean onItemOut(int index) {
        if (null != this.itemOutCallback) {
            this.itemOutCallback.accept(new PaletteItemEvent(this.getPaletteItemId(index)));
        }
        return true;
    }

    public boolean onItemMouseDown(int index, double mouseX, double mouseY, double itemX, double itemY) {
        if (null != this.itemMouseDownCallback) {
            String id = this.getPaletteItemId(index);
            return this.onItemMouseDown(id, mouseX, mouseY, itemX, itemY);
        }
        return true;
    }

    public boolean onItemMouseDown(String id, double mouseX, double mouseY, double itemX, double itemY) {
        if (null != this.itemMouseDownCallback) {
            this.itemMouseDownCallback.accept(new PaletteItemMouseEvent(id, mouseX, mouseY, itemX, itemY));
        }
        return true;
    }

    public boolean onItemClick(int index, double mouseX, double mouseY, double itemX, double itemY) {
        if (null != this.itemClickCallback) {
            String id = this.getPaletteItemId(index);
            this.itemClickCallback.accept(new PaletteItemMouseEvent(id, mouseX, mouseY, itemX, itemY));
        }
        return true;
    }

    public boolean onItemClick(String id, double mouseX, double mouseY, double itemX, double itemY) {
        if (null != this.itemClickCallback) {
            this.itemClickCallback.accept(new PaletteItemMouseEvent(id, mouseX, mouseY, itemX, itemY));
        }
        return true;
    }

    public D getDefinition() {
        return this.paletteDefinition;
    }

    public void destroy() {
        this.doDestroy();
        this.closeCallback = null;
        this.itemHoverCallback = null;
        this.itemOutCallback = null;
        this.itemMouseDownCallback = null;
        this.itemClickCallback = null;
        this.paletteDefinition = null;
    }

    public static interface PaletteDragProxyGlyphConsumer
    extends ShapeFactory.GlyphConsumer {
    }

    public static interface PaletteGlyphConsumer
    extends ShapeFactory.GlyphConsumer {
    }
}

