/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.proxies;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.components.proxies.ElementProxy;
import org.kie.workbench.common.stunner.core.client.components.proxies.ShapeProxy;
import org.kie.workbench.common.stunner.core.client.components.proxies.ShapeProxyView;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyDownEvent;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.view.event.AbstractMouseEvent;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

@Dependent
public class ConnectorProxy
implements ShapeProxy {
    private final ElementProxy proxy;
    private final ShapeProxyView<EdgeShape> view;
    private Edge<? extends ViewConnector<?>, Node> edge;
    private Node<? extends View<?>, Edge> sourceNode;

    @Inject
    public ConnectorProxy(ElementProxy proxy, ShapeProxyView<EdgeShape> view) {
        this.proxy = proxy;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.proxy.setView(this.view).setProxyBuilder(this::onCreateProxy);
    }

    public ConnectorProxy setCanvasHandler(AbstractCanvasHandler canvasHandler) {
        this.proxy.setCanvasHandler(canvasHandler);
        return this;
    }

    public ConnectorProxy setEdge(Edge<? extends ViewConnector<?>, Node> edge) {
        this.edge = edge;
        return this;
    }

    public ConnectorProxy setSourceNode(Node<? extends View<?>, Edge> sourceNode) {
        this.sourceNode = sourceNode;
        return this;
    }

    public ConnectorProxy start(AbstractMouseEvent event) {
        this.start(event.getX(), event.getY());
        return this;
    }

    @Override
    public void start(double x, double y) {
        this.proxy.start(x, y);
    }

    @Override
    public void destroy() {
        this.proxy.destroy();
        this.edge = null;
        this.sourceNode = null;
    }

    private EdgeShape onCreateProxy() {
        CanvasCommandFactory<AbstractCanvasHandler> commandFactory = this.proxy.lookupCanvasFactory();
        this.proxy.execute((Command<AbstractCanvasHandler, CanvasViolation>)commandFactory.addConnector(this.sourceNode, this.edge, (Connection)MagnetConnection.Builder.atCenter(this.sourceNode), this.getMetadata().getShapeSetId()));
        return this.getConnector();
    }

    void onKeyDownEvent(@Observes KeyDownEvent event) {
        this.proxy.handleCancelKey(event.getKey());
    }

    private EdgeShape getConnector() {
        return (EdgeShape)this.proxy.getCanvas().getShape(this.edge.getUUID());
    }

    private Metadata getMetadata() {
        return this.proxy.getCanvasHandler().getDiagram().getMetadata();
    }
}

