/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.HashMap;
import javax.enterprise.event.Event;
import javax.inject.Singleton;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.impl.AbstractSelectionAwareSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CopySelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.DeleteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Singleton
public class SessionSingletonCommandsFactory {
    private static HashMap<ClientSession, CopySelectionSessionCommand> copySessionInstances = new HashMap();
    private static HashMap<ClientSession, DeleteSelectionSessionCommand> deleteSessionInstances = new HashMap();

    public static void createOrPut(AbstractSelectionAwareSessionCommand<EditorSession> command, SessionManager sessionManager) {
        if (sessionManager == null) {
            throw new IllegalStateException("Session Manager is Null");
        }
        if (command instanceof CopySelectionSessionCommand) {
            if (copySessionInstances.containsKey(sessionManager.getCurrentSession())) {
                throw new IllegalStateException("Only one instance of CopySelectionSessionCommand per Client Session can exist");
            }
            copySessionInstances.put(sessionManager.getCurrentSession(), (CopySelectionSessionCommand)command);
        } else if (command instanceof DeleteSelectionSessionCommand) {
            if (deleteSessionInstances.containsKey(sessionManager.getCurrentSession())) {
                throw new IllegalStateException("Only one instance of DeleteSelectionSessionCommand per Client Session can exist");
            }
            deleteSessionInstances.put(sessionManager.getCurrentSession(), (DeleteSelectionSessionCommand)command);
        } else {
            throw new UnsupportedOperationException("Session Command Not Compatible Yet : " + command.getClass());
        }
    }

    public static CopySelectionSessionCommand getInstanceCopy(Event<?> commandExecutedEvent, SessionManager sessionManager) {
        ClientSession currentSession = sessionManager.getCurrentSession();
        if (!copySessionInstances.containsKey(currentSession)) {
            CopySelectionSessionCommand copySelectionSessionCommand = new CopySelectionSessionCommand(commandExecutedEvent, sessionManager);
            return copySelectionSessionCommand;
        }
        CopySelectionSessionCommand copySelectionSessionCommand = copySessionInstances.get(currentSession);
        return copySelectionSessionCommand;
    }

    public static DeleteSelectionSessionCommand getInstanceDelete(SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, ManagedInstance<CanvasCommandFactory<AbstractCanvasHandler>> canvasCommandFactoryInstance, Event<CanvasClearSelectionEvent> clearSelectionEvent, DefinitionUtils definitionUtils, SessionManager sessionManager) {
        ClientSession currentSession = sessionManager.getCurrentSession();
        if (!deleteSessionInstances.containsKey(currentSession)) {
            return new DeleteSelectionSessionCommand(sessionCommandManager, canvasCommandFactoryInstance, clearSelectionEvent, definitionUtils, sessionManager);
        }
        return deleteSessionInstances.get(currentSession);
    }
}

