/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractRegistrationCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveCanvasChildrenCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;

public class AddCanvasChildNodeCommand
extends AbstractRegistrationCanvasNodeCommand {
    private final Node parent;

    public AddCanvasChildNodeCommand(Node parent, Node candidate, String shapeSetId) {
        super(candidate, shapeSetId);
        this.parent = parent;
    }

    @Override
    protected void register(AbstractCanvasHandler context) {
        super.register(context);
        context.addChild((Element)this.parent, (Element)this.getCandidate());
    }

    @Override
    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        CommandResult<CanvasViolation> result = super.execute(context);
        context.applyElementMutation((Element)this.parent, MutationContext.STATIC);
        return result;
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new CompositeCommand.Builder().addCommand((Command)new RemoveCanvasChildrenCommand(this.parent, this.getCandidate())).addCommand((Command)new DeleteCanvasNodeCommand(this.getCandidate(), this.parent)).build().execute((Object)context);
    }

    public Node getParent() {
        return this.parent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [parent=" + AddCanvasChildNodeCommand.toUUID(this.parent) + ",candidate=" + AddCanvasChildNodeCommand.toUUID(this.getCandidate()) + ",shapeSet=" + this.getShapeSetId() + "]";
    }
}

