/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasUndockNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolationImpl;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.violations.DockingRuleViolation;

public class CanvasDockNodeCommand
extends AbstractCanvasCommand {
    private final Node parent;
    private final Node candidate;
    private final Optional<Consumer<Point2D>> dockedPositionCallback;

    public CanvasDockNodeCommand(Node parent, Node candidate) {
        this(parent, candidate, null);
    }

    public CanvasDockNodeCommand(Node parent, Node candidate, Consumer<Point2D> dockedPositionCallback) {
        this.parent = parent;
        this.candidate = candidate;
        this.dockedPositionCallback = Optional.ofNullable(dockedPositionCallback);
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        this.getCandidate().getInEdges().stream().filter(e -> e.getContent() instanceof Child).findAny().ifPresent(e -> context.removeChild((Element)e.getSourceNode(), (Element)this.candidate));
        ShapeView shapeView = context.getCanvas().getShape(this.candidate.getUUID()).getShapeView();
        Point2D currentPosition = new Point2D(shapeView.getShapeX(), shapeView.getShapeY());
        context.applyElementMutation((Element)this.parent, MutationContext.STATIC);
        context.applyElementMutation((Element)this.candidate, MutationContext.STATIC);
        if (!context.dock((Element)this.parent, (Element)this.candidate)) {
            return new CanvasCommandResultBuilder().addViolation(CanvasViolationImpl.Builder.build((RuleViolation)new DockingRuleViolation(this.parent.getUUID(), this.candidate.getUUID()))).build();
        }
        Point2D dockLocation = new Point2D(shapeView.getShapeX(), shapeView.getShapeY());
        if (!Objects.equals(currentPosition, dockLocation)) {
            this.dockedPositionCallback.ifPresent(callback -> callback.accept(dockLocation));
        }
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new CanvasUndockNodeCommand(this.parent, this.candidate).execute(context);
    }

    public Node getParent() {
        return this.parent;
    }

    public Node<?, Edge> getCandidate() {
        return this.candidate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [parent=" + this.getParent() + ",candidate=" + this.getCandidate() + "]";
    }
}

