/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCompositeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetConnectionSourceNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetConnectionTargetNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPositionCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.BoundingBox;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public class ResizeNodeCommand
extends AbstractCanvasCompositeCommand {
    private final Element<? extends View> candidate;
    private final BoundingBox boundingBox;
    private final BiFunction<Shape, Integer, Point2D> magnetLocationProvider;
    private final Consumer<Shape> onResize;
    private double widthBefore;
    private double heightBefore;

    public ResizeNodeCommand(Element<? extends View> candidate, BoundingBox boundingBox, BiFunction<Shape, Integer, Point2D> magnetLocationProvider) {
        this(candidate, boundingBox, magnetLocationProvider, shape -> {});
    }

    public ResizeNodeCommand(Element<? extends View> candidate, BoundingBox boundingBox, BiFunction<Shape, Integer, Point2D> magnetLocationProvider, Consumer<Shape> onResize) {
        this.candidate = candidate;
        this.boundingBox = boundingBox;
        this.magnetLocationProvider = magnetLocationProvider;
        this.onResize = onResize;
    }

    protected AbstractCompositeCommand<AbstractCanvasHandler, CanvasViolation> initialize(AbstractCanvasHandler context) {
        super.initialize((Object)context);
        this.widthBefore = ((View)this.candidate.getContent()).getBounds().getWidth();
        this.heightBefore = ((View)this.candidate.getContent()).getBounds().getHeight();
        double w = this.boundingBox.getMaxX();
        double h = this.boundingBox.getMaxY();
        List<Command<AbstractCanvasHandler, CanvasViolation>> commands = this.getResizeCommands(context, w, h);
        if (null != commands) {
            Node node = (Node)this.candidate;
            commands.forEach(arg_0 -> ((ResizeNodeCommand)this).addCommand(arg_0));
            if (GraphUtils.hasDockedNodes((Node)node)) {
                this.updateDockedNodesPosition(context, node);
            }
            if (GraphUtils.hasConnections((Node)node)) {
                this.updateConnectionsPositions(context, node);
            }
        }
        return this;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        CommandResult result = super.execute((Object)context);
        return this.postOperation(context, (CommandResult<CanvasViolation>)result, this.boundingBox.getMaxX(), this.boundingBox.getMaxY());
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        CommandResult result = super.undo((Object)context);
        return this.postOperation(context, (CommandResult<CanvasViolation>)result, this.widthBefore, this.heightBefore);
    }

    public Element<? extends View> getCandidate() {
        return this.candidate;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public BiFunction<Shape, Integer, Point2D> getMagnetLocationProvider() {
        return this.magnetLocationProvider;
    }

    public Consumer<Shape> getOnResize() {
        return this.onResize;
    }

    CommandResult<CanvasViolation> postOperation(AbstractCanvasHandler context, CommandResult<CanvasViolation> result, double width, double height) {
        if (!CommandUtils.isError(result)) {
            Point2D current = GraphUtils.getPosition((View)((View)this.candidate.getContent()));
            Bounds newBounds = Bounds.create((double)current.getX(), (double)current.getY(), (double)(current.getX() + width), (double)(current.getY() + height));
            ((View)this.candidate.getContent()).setBounds(newBounds);
            ShapeView shapeView = ResizeNodeCommand.getShape(context, this.candidate.getUUID()).getShapeView();
            ShapeUtils.setSizeFromBoundingBox(shapeView, width, height);
            this.onResize.accept(ResizeNodeCommand.getShape(context, this.candidate.getUUID()));
        }
        return result;
    }

    private void updateConnectionsPositions(AbstractCanvasHandler canvasHandler, Node<View<?>, Edge> node) {
        GraphUtils.getSourceConnections(node).forEach(edge -> ((ViewConnector)edge.getContent()).getSourceConnection().ifPresent(connection -> this.handleConnections(canvasHandler, node, () -> connection, () -> new SetConnectionSourceNodeCommand((Node<? extends View<?>, Edge>)node, (Edge<? extends ViewConnector<?>, Node>)edge, (Connection)connection))));
        GraphUtils.getTargetConnections(node).forEach(edge -> ((ViewConnector)edge.getContent()).getTargetConnection().ifPresent(connection -> this.handleConnections(canvasHandler, node, () -> connection, () -> new SetConnectionTargetNodeCommand((Node<? extends View<?>, Edge>)node, (Edge<? extends ViewConnector<?>, Node>)edge, (Connection)connection))));
    }

    private void handleConnections(AbstractCanvasHandler canvasHandler, Node<View<?>, Edge> node, Supplier<Connection> connectionSupplier, Supplier<CanvasCommand<AbstractCanvasHandler>> commandSupplier) {
        Connection connection = connectionSupplier.get();
        if (Objects.isNull(connection) || !(connection instanceof MagnetConnection)) {
            return;
        }
        MagnetConnection magnetConnection = (MagnetConnection)connection;
        magnetConnection.getMagnetIndex().ifPresent(index -> {
            Shape shape = ResizeNodeCommand.getShape(canvasHandler, node.getUUID());
            if (null != shape) {
                Point2D location = this.magnetLocationProvider.apply(shape, index);
                magnetConnection.setLocation(location);
                this.addCommand((Command)commandSupplier.get());
            }
        });
    }

    private void updateDockedNodesPosition(AbstractCanvasHandler canvasHandler, Node<View<?>, Edge> node) {
        GraphUtils.getDockedNodes(node).stream().forEach(docked -> {
            Shape shape = ResizeNodeCommand.getShape(canvasHandler, docked.getUUID());
            double dockedX = shape.getShapeView().getShapeX();
            double dockedY = shape.getShapeView().getShapeY();
            this.addCommand((Command)new UpdateElementPositionCommand((Node<View<?>, Edge>)docked, new Point2D(dockedX, dockedY)));
        });
    }

    private static Shape getShape(AbstractCanvasHandler canvasHandler, String uuid) {
        return canvasHandler.getCanvas().getShape(uuid);
    }

    private List<Command<AbstractCanvasHandler, CanvasViolation>> getResizeCommands(AbstractCanvasHandler canvasHandler, double w, double h) {
        Object radius;
        Object height;
        Definition content = (Definition)this.candidate.getContent();
        Object def = content.getDefinition();
        DefinitionAdapter adapter = canvasHandler.getDefinitionManager().adapters().registry().getDefinitionAdapter(def.getClass());
        LinkedList<Command<AbstractCanvasHandler, CanvasViolation>> result = new LinkedList<Command<AbstractCanvasHandler, CanvasViolation>>();
        Object width = adapter.getMetaProperty(PropertyMetaTypes.WIDTH, def);
        if (null != width) {
            this.appendCommandForModelProperty(canvasHandler, width, w, result);
        }
        if (null != (height = adapter.getMetaProperty(PropertyMetaTypes.HEIGHT, def))) {
            this.appendCommandForModelProperty(canvasHandler, height, h, result);
        }
        if (null != (radius = adapter.getMetaProperty(PropertyMetaTypes.RADIUS, def))) {
            double r = w > h ? h / 2.0 : w / 2.0;
            this.appendCommandForModelProperty(canvasHandler, radius, r, result);
        }
        return result;
    }

    private void appendCommandForModelProperty(AbstractCanvasHandler canvasHandler, Object property, Object value, List<Command<AbstractCanvasHandler, CanvasViolation>> result) {
        String id = canvasHandler.getDefinitionManager().adapters().forProperty().getId(property);
        result.add((Command<AbstractCanvasHandler, CanvasViolation>)new UpdateElementPropertyCommand(this.candidate, id, value));
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [candidate=" + AbstractCanvasCommand.toUUID(this.candidate) + ",box=" + this.boundingBox + "]";
    }
}

