/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.clipboard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.ClipboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.EdgeClipboard;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

@ApplicationScoped
@Default
public class LocalClipboardControl
extends AbstractCanvasControl<AbstractCanvas>
implements ClipboardControl<Element, AbstractCanvas, ClientSession> {
    private final Set<Element> elements;
    private final Map<String, String> elementsParent;
    private final List<Command> commands;
    private Map<String, EdgeClipboard> edgeMap = new HashMap<String, EdgeClipboard>();

    public LocalClipboardControl() {
        this.elements = new HashSet<Element>();
        this.elementsParent = new HashMap<String, String>();
        this.commands = new ArrayList<Command>();
    }

    public ClipboardControl<Element, AbstractCanvas, ClientSession> set(Element ... element) {
        this.clear();
        this.elements.addAll(Arrays.stream(element).collect(Collectors.toSet()));
        this.elementsParent.putAll(this.elements.stream().filter(e -> e instanceof Node).collect(Collectors.toMap(Element::getUUID, e -> GraphUtils.getParent((Node)e.asNode()).getUUID())));
        return this;
    }

    public ClipboardControl<Element, AbstractCanvas, ClientSession> remove(Element ... element) {
        this.elements.removeAll(Arrays.stream(element).collect(Collectors.toSet()));
        return this;
    }

    public Collection<Element> getElements() {
        return this.elements;
    }

    public ClipboardControl<Element, AbstractCanvas, ClientSession> clear() {
        this.commands.clear();
        this.elements.clear();
        this.elementsParent.clear();
        return this;
    }

    public boolean hasElements() {
        return !this.elements.isEmpty();
    }

    public String getParent(String uuid) {
        return this.elementsParent.get(uuid);
    }

    public List<Command> getRollbackCommands() {
        return this.commands;
    }

    public ClipboardControl<Element, AbstractCanvas, ClientSession> setRollbackCommand(Command ... command) {
        this.commands.clear();
        this.commands.addAll(Stream.of(command).collect(Collectors.toList()));
        return this;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doDestroy() {
        this.clear();
    }

    public Map<String, EdgeClipboard> getEdgeMap() {
        return this.edgeMap;
    }

    public EdgeClipboard buildNewEdgeClipboard(String source, Connection sourceConnection, String target, Connection targetConnection) {
        EdgeClipboard clipboard = new EdgeClipboard();
        clipboard.setSource(source);
        clipboard.setSourceConnection(sourceConnection);
        clipboard.setTarget(target);
        clipboard.setTargetConnection(targetConnection);
        return clipboard;
    }
}

