/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.MouseRequestLifecycle;
import org.kie.workbench.common.stunner.core.client.command.RegistryAwareCommandManager;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.exception.CommandException;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;

@ApplicationScoped
@Typed(value={SessionCommandManager.class})
public class ApplicationCommandManager
implements SessionCommandManager<AbstractCanvasHandler> {
    private final SessionManager sessionManager;
    private final MouseRequestLifecycle lifecycle;
    private final ManagedInstance<RegistryAwareCommandManager> commandManagerInstances;
    private final Map<String, RegistryAwareCommandManager> commandManagers;

    @Inject
    public ApplicationCommandManager(SessionManager sessionManager, MouseRequestLifecycle lifecycle, @Any ManagedInstance<RegistryAwareCommandManager> commandManagerInstances) {
        this.sessionManager = sessionManager;
        this.lifecycle = lifecycle;
        this.commandManagerInstances = commandManagerInstances;
        this.commandManagers = new HashMap<String, RegistryAwareCommandManager>(3);
    }

    @PostConstruct
    public void init() {
        this.lifecycle.listen(() -> this);
    }

    public void start() {
        this.getDelegate().start();
    }

    public void rollback() {
        this.getDelegate().rollback();
    }

    public void complete() {
        this.getDelegate().complete();
    }

    public CommandResult<CanvasViolation> allow(Command<AbstractCanvasHandler, CanvasViolation> command) {
        return this.runExceptionSafeOperation(() -> this.getDelegate().allow(command));
    }

    public CommandResult<CanvasViolation> execute(Command<AbstractCanvasHandler, CanvasViolation> command) {
        return this.runSafeOperation(() -> this.getDelegate().execute(command));
    }

    public CommandResult<CanvasViolation> undo() {
        return this.runSafeOperation(() -> this.getDelegate().undo());
    }

    public CommandResult<CanvasViolation> allow(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command) {
        return this.runExceptionSafeOperation(() -> this.getDelegate().allow(context, command));
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command) {
        return this.runSafeOperation(() -> this.getDelegate().execute(context, command));
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command) {
        return this.runSafeOperation(() -> this.getDelegate().undo(context, command));
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return this.runSafeOperation(() -> this.getDelegate().undo(context));
    }

    @PreDestroy
    public void destroy() {
        this.getCommandManagers().clear();
        this.commandManagerInstances.destroyAll();
    }

    void onSessionDestroyed(@Observes SessionDestroyedEvent event) {
        String sessionUUID = event.getSessionUUID();
        RegistryAwareCommandManager commandManager = this.getCommandManagers().get(sessionUUID);
        this.commandManagerInstances.destroy((Object)commandManager);
        this.getCommandManagers().remove(sessionUUID);
    }

    Map<String, RegistryAwareCommandManager> getCommandManagers() {
        return this.commandManagers;
    }

    private CommandResult<CanvasViolation> runSafeOperation(Supplier<CommandResult<CanvasViolation>> operation) {
        CommandResult<CanvasViolation> result = this.runExceptionSafeOperation(operation);
        if (CommandUtils.isError(result)) {
            this.rollback();
        }
        return result;
    }

    private CommandResult<CanvasViolation> runExceptionSafeOperation(Supplier<CommandResult<CanvasViolation>> operation) {
        return this.runExceptionSafeOperation(operation, result -> {});
    }

    private CommandResult<CanvasViolation> runExceptionSafeOperation(Supplier<CommandResult<CanvasViolation>> operation, Consumer<CommandResult<CanvasViolation>> postOperation) {
        CommandResult<CanvasViolation> result = null;
        try {
            result = operation.get();
            if (!CommandUtils.isError(result)) {
                postOperation.accept(result);
            }
        }
        catch (CommandException ce) {
            this.sessionManager.handleCommandError(ce);
            result = CanvasCommandResultBuilder.failed();
        }
        catch (RuntimeException e) {
            this.sessionManager.handleClientError(new ClientRuntimeError((Throwable)e));
            result = CanvasCommandResultBuilder.failed();
        }
        return result;
    }

    private RegistryAwareCommandManager getDelegate() {
        ClientSession session = this.getCurrentSession();
        String sessionUUID = session.getSessionUUID();
        RegistryAwareCommandManager commandManager = this.getCommandManagers().get(sessionUUID);
        if (null == commandManager) {
            commandManager = ((RegistryAwareCommandManager)this.commandManagerInstances.get()).init(session);
            this.getCommandManagers().put(sessionUUID, commandManager);
        }
        return commandManager;
    }

    private ClientSession getCurrentSession() {
        return this.sessionManager.getCurrentSession();
    }
}

