/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.layout;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPositionCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Layout;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.core.graph.processing.layout.VertexPosition;

public class UndoableLayoutExecutor
implements LayoutExecutor {
    private final AbstractCanvasHandler canvasHandler;
    private final CanvasCommandManager<AbstractCanvasHandler> commandManager;

    public UndoableLayoutExecutor(AbstractCanvasHandler canvasHandler, CanvasCommandManager<AbstractCanvasHandler> commandManager) {
        this.canvasHandler = canvasHandler;
        this.commandManager = commandManager;
    }

    public void applyLayout(Layout layout, Graph graph) {
        if (layout.getNodePositions().size() == 0) {
            return;
        }
        CompositeCommand command = this.createCommand(layout, graph);
        this.commandManager.execute((Object)this.canvasHandler, (Command)command);
    }

    CompositeCommand createCommand(Layout layout, Graph graph) {
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder();
        for (int i = 0; i < layout.getNodePositions().size(); ++i) {
            VertexPosition position = (VertexPosition)layout.getNodePositions().get(i);
            Node node = graph.getNode(position.getId());
            commandBuilder.addCommand((Command)new UpdateElementPositionCommand(node, position.getUpperLeft()));
        }
        return commandBuilder.build();
    }

    public AbstractCanvasHandler getCanvasHandler() {
        return this.canvasHandler;
    }

    public CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManager;
    }
}

