/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.lang.annotation.Annotation;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.api.ClientFactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.components.proxies.NodeProxy;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.FlowActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.GeneralCreateNodeAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.IsToolboxActionDraggable;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.client.shape.view.event.AbstractMouseEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseMoveEvent;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.HashUtil;
import org.kie.workbench.common.stunner.core.util.UUID;

@Dependent
@FlowActionsToolbox
@Default
public class CreateNodeToolboxAction
extends AbstractToolboxAction
implements IsToolboxActionDraggable<AbstractCanvasHandler> {
    static final String KEY_TITLE = "org.kie.workbench.common.stunner.core.client.toolbox.createNewNode";
    private final ManagedInstance<GeneralCreateNodeAction> createNodeActions;
    private final ClientFactoryManager clientFactoryManager;
    private final NodeProxy nodeProxy;
    private String nodeId;
    private String edgeId;

    @Inject
    public CreateNodeToolboxAction(@Any ManagedInstance<GeneralCreateNodeAction> createNodeActions, DefinitionUtils definitionUtils, ClientTranslationService translationService, ClientFactoryManager clientFactoryManager, NodeProxy nodeProxy) {
        super(definitionUtils, translationService);
        this.createNodeActions = createNodeActions;
        this.clientFactoryManager = clientFactoryManager;
        this.nodeProxy = nodeProxy;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public CreateNodeToolboxAction setNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public CreateNodeToolboxAction setEdgeId(String edgeId) {
        this.edgeId = edgeId;
        return this;
    }

    @Override
    protected String getTitleKey(AbstractCanvasHandler canvasHandler, String uuid) {
        return KEY_TITLE;
    }

    @Override
    protected String getTitleDefinitionId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.nodeId;
    }

    @Override
    protected String getGlyphId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.nodeId;
    }

    @Override
    public ToolboxAction<AbstractCanvasHandler> onMouseClick(AbstractCanvasHandler canvasHandler, String uuid, MouseClickEvent event) {
        GeneralCreateNodeAction action = this.lookupAction(canvasHandler, uuid);
        action.executeAction(canvasHandler, uuid, this.nodeId, this.edgeId);
        return this;
    }

    private GeneralCreateNodeAction lookupAction(AbstractCanvasHandler canvasHandler, String uuid) {
        Metadata metadata = canvasHandler.getDiagram().getMetadata();
        Annotation qualifier = this.getDefinitionUtils().getQualifier(metadata.getDefinitionSetId());
        return InstanceUtils.lookup(this.createNodeActions, qualifier);
    }

    @Override
    public ToolboxAction<AbstractCanvasHandler> onMoveStart(AbstractCanvasHandler canvasHandler, String uuid, MouseMoveEvent event) {
        Node<View<?>, Edge> sourceNode = this.getSourceNode(canvasHandler, uuid);
        Edge<ViewConnector<?>, Node> connector = this.buildEdge();
        Node<View<?>, Edge> targetNode = this.buildTargetNode();
        this.nodeProxy.setTargetNode(targetNode).setEdge(connector).setSourceNode(sourceNode).setCanvasHandler(canvasHandler).start((AbstractMouseEvent)event);
        return this;
    }

    @PreDestroy
    public void destroy() {
        this.createNodeActions.destroyAll();
        this.nodeProxy.destroy();
        this.nodeId = null;
        this.edgeId = null;
    }

    private Node<View<?>, Edge> getSourceNode(AbstractCanvasHandler canvasHandler, String uuid) {
        Element<? extends Definition<?>> sourceElement = CanvasLayoutUtils.getElement(canvasHandler, uuid);
        return sourceElement.asNode();
    }

    private Edge<ViewConnector<?>, Node> buildEdge() {
        return this.clientFactoryManager.newElement(UUID.uuid(), this.edgeId).asEdge();
    }

    private Node<View<?>, Edge> buildTargetNode() {
        return this.clientFactoryManager.newElement(UUID.uuid(), this.nodeId).asNode();
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{this.edgeId.hashCode(), this.nodeId.hashCode()});
    }

    public boolean equals(Object o) {
        if (o instanceof CreateNodeToolboxAction) {
            CreateNodeToolboxAction other = (CreateNodeToolboxAction)o;
            return other.edgeId.equals(this.edgeId) && other.nodeId.equals(this.nodeId);
        }
        return false;
    }
}

