/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.lang.annotation.Annotation;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.api.ClientFactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.DefaultCanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.CreateNodeAction;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.DeferredCompositeCommand;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.UUID;

@Dependent
@Default
public class GeneralCreateNodeAction
implements CreateNodeAction<AbstractCanvasHandler> {
    private final DefinitionUtils definitionUtils;
    private final ClientFactoryManager clientFactoryManager;
    private final CanvasLayoutUtils canvasLayoutUtils;
    private final Event<CanvasSelectionEvent> selectionEvent;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final ManagedInstance<DefaultCanvasCommandFactory> canvasCommandFactories;

    @Inject
    public GeneralCreateNodeAction(DefinitionUtils definitionUtils, ClientFactoryManager clientFactoryManager, CanvasLayoutUtils canvasLayoutUtils, Event<CanvasSelectionEvent> selectionEvent, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, @Any ManagedInstance<DefaultCanvasCommandFactory> canvasCommandFactories) {
        this.definitionUtils = definitionUtils;
        this.clientFactoryManager = clientFactoryManager;
        this.canvasLayoutUtils = canvasLayoutUtils;
        this.selectionEvent = selectionEvent;
        this.sessionCommandManager = sessionCommandManager;
        this.canvasCommandFactories = canvasCommandFactories;
    }

    public void executeAction(AbstractCanvasHandler canvasHandler, String sourceNodeId, String targetNodeId, String connectorId) {
        Element<? extends Definition<?>> element = CanvasLayoutUtils.getElement(canvasHandler, sourceNodeId);
        Node sourceNode = element.asNode();
        Edge connector = this.clientFactoryManager.newElement(UUID.uuid(), connectorId).asEdge();
        Node targetNode = this.clientFactoryManager.newElement(UUID.uuid(), targetNodeId).asNode();
        Metadata metadata = canvasHandler.getDiagram().getMetadata();
        Annotation qualifier = this.definitionUtils.getQualifier(metadata.getDefinitionSetId());
        CanvasCommandFactory commandFactory = InstanceUtils.lookup(this.canvasCommandFactories, qualifier);
        DeferredCompositeCommand.Builder builder = new DeferredCompositeCommand.Builder().deferCommand(() -> this.addNode(canvasHandler, (CanvasCommandFactory<AbstractCanvasHandler>)commandFactory, sourceNode, targetNode)).deferCommand(() -> this.updateNodeLocation(canvasHandler, (CanvasCommandFactory<AbstractCanvasHandler>)commandFactory, sourceNode, targetNode)).deferCommand(() -> this.addEdge(canvasHandler, (CanvasCommandFactory<AbstractCanvasHandler>)commandFactory, sourceNode, targetNode, connector)).deferCommand(() -> this.setEdgeTarget((CanvasCommandFactory<AbstractCanvasHandler>)commandFactory, connector, targetNode, sourceNode));
        CommandResult result = this.sessionCommandManager.execute((Object)canvasHandler, (Command)builder.build());
        if (!CommandUtils.isError((CommandResult)result)) {
            CanvasLayoutUtils.fireElementSelectedEvent(this.selectionEvent, canvasHandler, targetNode.getUUID());
        }
    }

    @PreDestroy
    public void destroy() {
        this.canvasCommandFactories.destroyAll();
    }

    private CanvasCommand<AbstractCanvasHandler> updateNodeLocation(AbstractCanvasHandler canvasHandler, CanvasCommandFactory<AbstractCanvasHandler> commandFactory, Node<View<?>, Edge> sourceNode, Node<View<?>, Edge> targetNode) {
        Point2D location = this.canvasLayoutUtils.getNext(canvasHandler, sourceNode, targetNode);
        return commandFactory.updatePosition(targetNode, location);
    }

    private CanvasCommand<AbstractCanvasHandler> addEdge(CanvasHandler canvasHandler, CanvasCommandFactory<AbstractCanvasHandler> commandFactory, Node<View<?>, Edge> sourceNode, Node<View<?>, Edge> targetNode, Edge<? extends ViewConnector<?>, Node> connector) {
        return commandFactory.addConnector(sourceNode, connector, (Connection)this.buildConnectionBetween(sourceNode, targetNode), canvasHandler.getDiagram().getMetadata().getShapeSetId());
    }

    protected MagnetConnection buildConnectionBetween(Node<View<?>, Edge> sourceNode, Node<View<?>, Edge> targetNode) {
        return MagnetConnection.Builder.forTarget(sourceNode, targetNode);
    }

    private CanvasCommand<AbstractCanvasHandler> setEdgeTarget(CanvasCommandFactory<AbstractCanvasHandler> commandFactory, Edge<? extends ViewConnector<?>, Node> connector, Node<View<?>, Edge> targetNode, Node<View<?>, Edge> sourceNode) {
        return commandFactory.setTargetNode(targetNode, connector, (Connection)this.buildConnectionBetween(targetNode, sourceNode));
    }

    private CanvasCommand<AbstractCanvasHandler> addNode(CanvasHandler canvasHandler, CanvasCommandFactory<AbstractCanvasHandler> commandFactory, Node<View<?>, Edge> sourceNode, Node<View<?>, Edge> targetNode) {
        Node parent = (Node)GraphUtils.getParent(sourceNode);
        String shapeSetId = canvasHandler.getDiagram().getMetadata().getShapeSetId();
        if (null != parent) {
            return commandFactory.addChildNode(parent, targetNode, shapeSetId);
        }
        return commandFactory.addNode(targetNode, shapeSetId);
    }
}

