/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.error;

import java.util.Objects;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.error.ClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.definition.exception.DefinitionNotFoundException;

public class DiagramClientErrorHandler
extends ClientErrorHandler {
    @Inject
    public DiagramClientErrorHandler(ClientTranslationService translationService) {
        super(translationService);
    }

    @Override
    public void handleError(ClientRuntimeError error, Consumer<String> showError) {
        if (Objects.isNull(error)) {
            throw new RuntimeException("Error cannot be null");
        }
        String message = null;
        if (error.getThrowable() instanceof DefinitionNotFoundException) {
            message = this.translationService.getValue("org.kie.workbench.common.stunner.core.client.diagram.load.fail.unsupported", ((DefinitionNotFoundException)error.getThrowable()).getDefinitionId());
        }
        showError.accept(Objects.nonNull(message) ? message : error.toString());
    }
}

