/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.AbstractShape;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;

public class ShapeImpl<V extends ShapeView>
extends AbstractShape<V> {
    private final V view;
    private final ShapeStateHandler shapeStateHandler;
    private String uuid;

    public ShapeImpl(V view, ShapeStateHandler shapeStateHandler) {
        this.view = view;
        this.shapeStateHandler = shapeStateHandler;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
        this.view.setUUID(uuid);
    }

    public String getUUID() {
        return this.uuid;
    }

    @Override
    public void beforeDraw() {
    }

    @Override
    public void afterDraw() {
        if (this.view instanceof HasTitle) {
            ((HasTitle)this.view).moveTitleToTop();
        }
    }

    @Override
    public void applyState(ShapeState shapeState) {
        this.shapeStateHandler.applyState(shapeState);
    }

    @Override
    public ShapeStateHandler getShapeStateHandler() {
        return this.shapeStateHandler;
    }

    public V getShapeView() {
        return this.view;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShapeImpl)) {
            return false;
        }
        ShapeImpl that = (ShapeImpl)o;
        return this.uuid != null && this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid == null ? 0 : ~(~this.uuid.hashCode());
    }
}

