/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.api;

import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.OnSessionErrorEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.command.exception.CommandException;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
public class GlobalSessionManager
implements SessionManager {
    private final Function<Metadata, Annotation> qualifierProvider = metadata -> definitionUtils.getQualifier(metadata.getDefinitionSetId());
    private final ManagedInstance<ClientSession> sessionInstances;
    private final Event<SessionOpenedEvent> sessionOpenedEvent;
    private final Event<SessionDestroyedEvent> sessionDestroyedEvent;
    private final Event<OnSessionErrorEvent> sessionErrorEvent;
    private AbstractSession current;

    protected GlobalSessionManager() {
        this(null, null, null, null, null);
    }

    @Inject
    public GlobalSessionManager(DefinitionUtils definitionUtils, @Any ManagedInstance<ClientSession> sessionInstances, Event<SessionOpenedEvent> sessionOpenedEvent, Event<SessionDestroyedEvent> sessionDestroyedEvent, Event<OnSessionErrorEvent> sessionErrorEvent) {
        this.sessionInstances = sessionInstances;
        this.sessionOpenedEvent = sessionOpenedEvent;
        this.sessionDestroyedEvent = sessionDestroyedEvent;
        this.sessionErrorEvent = sessionErrorEvent;
    }

    public <S extends ClientSession> void newSession(Metadata metadata, Class<S> sessionType, Consumer<S> sessionConsumer) {
        ClientSession session = (ClientSession)InstanceUtils.lookup(this.sessionInstances, sessionType, this.qualifierProvider.apply(metadata));
        ((AbstractSession)session).init(metadata, () -> sessionConsumer.accept(session));
    }

    public <S extends ClientSession> void open(S session) {
        PortablePreconditions.checkNotNull((String)"session", session);
        if (!session.equals(this.current)) {
            this.current = (AbstractSession)session;
            this.current.open();
            this.sessionOpenedEvent.fire((Object)new SessionOpenedEvent((ClientSession)this.current));
        }
    }

    public <S extends ClientSession> void destroy(S session) {
        boolean isCurrent = session.equals(this.current);
        String uuid = session.getSessionUUID();
        Diagram diagram = session.getCanvasHandler().getDiagram();
        String name = null != diagram ? diagram.getName() : null;
        String graphUuid = null != diagram ? diagram.getGraph().getUUID() : null;
        Metadata metadata = null != diagram ? diagram.getMetadata() : null;
        ((AbstractSession)session).destroy();
        this.sessionInstances.destroy(session);
        if (isCurrent) {
            this.current = null;
        }
        this.sessionDestroyedEvent.fire((Object)new SessionDestroyedEvent(uuid, name, graphUuid, metadata));
    }

    public <S extends ClientSession> S getCurrentSession() {
        return (S)this.current;
    }

    public void handleCommandError(CommandException ce) {
        this.sessionErrorEvent.fire((Object)new OnSessionErrorEvent((ClientSession)this.current, new ClientRuntimeError("Error while executing command.", (Throwable)ce)));
    }

    public void handleClientError(ClientRuntimeError error) {
        this.sessionErrorEvent.fire((Object)new OnSessionErrorEvent((ClientSession)this.current, error));
    }
}

