/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.api;

import com.google.gwt.safehtml.shared.SafeUri;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.ShapeSet;
import org.kie.workbench.common.stunner.core.client.ShapeSetThumbProvider;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;

@ApplicationScoped
public class ShapeManagerImpl
implements ShapeManager {
    private final ManagedInstance<ShapeSet> shapeSetsInstances;
    private final ManagedInstance<ShapeSetThumbProvider> thumbProvidersInstances;
    private final List<ShapeSet<?>> shapeSets = new LinkedList();
    private final List<ShapeSetThumbProvider> thumbProviders = new LinkedList<ShapeSetThumbProvider>();

    protected ShapeManagerImpl() {
        this(null, null);
    }

    @Inject
    public ShapeManagerImpl(@Any ManagedInstance<ShapeSet> shapeSetsInstances, @Any ManagedInstance<ShapeSetThumbProvider> thumbProvidersInstances) {
        this.shapeSetsInstances = shapeSetsInstances;
        this.thumbProvidersInstances = thumbProvidersInstances;
    }

    @PostConstruct
    public void init() {
        this.shapeSetsInstances.forEach(this.shapeSets::add);
        this.thumbProvidersInstances.forEach(this.thumbProviders::add);
    }

    public Collection<ShapeSet<?>> getShapeSets() {
        return this.shapeSets;
    }

    public ShapeSet<?> getShapeSet(String id) {
        PortablePreconditions.checkNotNull((String)"id", (Object)id);
        return this.shapeSets.stream().filter(s -> id.equals(s.getId())).findFirst().orElse(null);
    }

    public ShapeSet<?> getDefaultShapeSet(String defSetId) {
        PortablePreconditions.checkNotNull((String)"defSetId", (Object)defSetId);
        return this.shapeSets.stream().filter(s -> defSetId.equals(s.getDefinitionSetId())).findFirst().orElse(null);
    }

    public SafeUri getThumbnail(String definitionSetId) {
        PortablePreconditions.checkNotNull((String)"definitionSetId", (Object)definitionSetId);
        ShapeSetThumbProvider p = this.thumbProviders.stream().filter(t -> t.thumbFor((Object)definitionSetId)).findFirst().orElse(null);
        return null != p ? p.getThumbnailUri() : null;
    }
}

