/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.view.HasManageableControlPoints;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

public class AddCanvasConnectorCommand
extends AbstractCanvasCommand {
    private final Edge candidate;
    private final String shapeSetId;

    public AddCanvasConnectorCommand(Edge candidate, String shapeSetId) {
        this.candidate = candidate;
        this.shapeSetId = shapeSetId;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        context.register(this.shapeSetId, (Element<View<?>>)this.candidate);
        if (this.candidate.getContent() instanceof ViewConnector) {
            HasManageableControlPoints view = (HasManageableControlPoints)ShapeUtils.getConnectorShape(this.candidate, context).getShapeView();
            ControlPoint[] controlPoints = ((ViewConnector)this.candidate.getContent()).getControlPoints();
            if (null != controlPoints) {
                for (int i = 0; i < controlPoints.length; ++i) {
                    view.addControlPoint(controlPoints[i], i);
                }
            }
        }
        ShapeUtils.applyConnections(this.candidate, context, MutationContext.STATIC);
        context.applyElementMutation((Element)this.candidate, MutationContext.STATIC);
        Node source = this.candidate.getSourceNode();
        if (null != source) {
            context.notifyCanvasElementUpdated((Element)source);
        }
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new DeleteCanvasConnectorCommand(this.candidate).execute(context);
    }

    public Edge getCandidate() {
        return this.candidate;
    }

    public String getShapeSetId() {
        return this.shapeSetId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [candidate=" + AddCanvasConnectorCommand.toUUID(this.candidate) + ",shapeSet=" + this.getShapeSetId() + "]";
    }
}

