/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.function.Consumer;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasControlPointCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.impl.ConnectorShape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasManageableControlPoints;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.util.ControlPointValidations;

public class AddCanvasControlPointCommand
extends AbstractCanvasCommand {
    private final Edge candidate;
    private final ControlPoint controlPoint;
    private final int index;

    public AddCanvasControlPointCommand(Edge candidate, ControlPoint controlPoint, int index) {
        this.candidate = candidate;
        this.controlPoint = controlPoint;
        this.index = index;
    }

    @Override
    public CommandResult<CanvasViolation> allow(AbstractCanvasHandler context) {
        ControlPointValidations.checkAddControlPoint((ControlPoint[])AddCanvasControlPointCommand.getViewControlPoints(context, this.candidate), (ControlPoint)this.controlPoint, (int)this.index);
        return CanvasCommandResultBuilder.SUCCESS;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        this.allow(context);
        AddCanvasControlPointCommand.consumeControlPoints(context, this.candidate, view -> view.addControlPoint(this.controlPoint, this.index));
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new DeleteCanvasControlPointCommand(this.candidate, this.index).execute(context);
    }

    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public int getIndex() {
        return this.index;
    }

    public static ControlPoint[] getControlPoints(Edge edge) {
        ViewConnector connector = (ViewConnector)edge.getContent();
        return connector.getControlPoints();
    }

    public static void consumeControlPoints(AbstractCanvasHandler context, Edge edge, Consumer<HasManageableControlPoints> consumer) {
        HasManageableControlPoints<?> view = AddCanvasControlPointCommand.getManageableControlPoints(context, edge);
        boolean visible = view.areControlsVisible();
        if (visible) {
            view.hideControlPoints();
        }
        consumer.accept(view);
        if (visible) {
            view.showControlPoints(HasControlPoints.ControlPointType.POINTS);
        }
    }

    public static HasManageableControlPoints<?> getManageableControlPoints(AbstractCanvasHandler context, Edge candidate) {
        ConnectorShape shape = ShapeUtils.getConnectorShape(candidate, context);
        return (HasManageableControlPoints)shape.getShapeView();
    }

    public static ControlPoint[] getViewControlPoints(AbstractCanvasHandler context, Edge candidate) {
        return AddCanvasControlPointCommand.getManageableControlPoints(context, candidate).getManageableControlPoints();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [controlPoint=" + this.controlPoint + ",index=" + this.index + "]";
    }
}

