/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasUnhighlightEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;

@Dependent
public class CanvasHighlight {
    private final Set<String> uuids = new HashSet<String>();
    private AbstractCanvasHandler canvasHandler;

    public CanvasHighlight setCanvasHandler(AbstractCanvasHandler canvasHandler) {
        this.canvasHandler = canvasHandler;
        return this;
    }

    public CanvasHighlight highLight(Element<?> node) {
        this.applyState(node, ShapeState.HIGHLIGHT);
        return this;
    }

    public CanvasHighlight invalid(Element<?> node) {
        this.applyState(node, ShapeState.INVALID);
        return this;
    }

    public CanvasHighlight invalid(RuleViolations violations) {
        this.invalid(violations.violations());
        return this;
    }

    public CanvasHighlight invalid(Iterable<? extends RuleViolation> violations) {
        violations.forEach(v -> {
            String uuid = v.getUUID();
            this.applyStateToShape(uuid, ShapeState.INVALID);
        });
        return this;
    }

    public CanvasHighlight none(Element<?> node) {
        this.applyState(node, ShapeState.NONE);
        return this;
    }

    public CanvasHighlight unhighLight() {
        if (!this.uuids.isEmpty()) {
            HashSet<String> copy = new HashSet<String>(this.uuids);
            this.uuids.clear();
            copy.forEach(uuid -> {
                Shape shape = this.getShape((String)uuid);
                if (null != shape) {
                    shape.applyState(ShapeState.NONE);
                }
            });
        }
        this.setCursor(AbstractCanvas.Cursors.MOVE);
        return this;
    }

    public void destroy() {
        this.setValidCursor();
        this.uuids.clear();
        this.canvasHandler = null;
    }

    private void applyState(Element<?> node, ShapeState state) {
        this.applyStateToShape(node.getUUID(), state);
    }

    private void applyStateToShape(String uuid, ShapeState state) {
        Shape shape = this.getShape(uuid);
        if (null != shape) {
            this.uuids.add(uuid);
            shape.applyState(state);
        }
        if (ShapeState.INVALID.equals((Object)state)) {
            this.setInvalidCursor();
        } else {
            this.setValidCursor();
        }
    }

    void onCanvasUnhighlightEvent(@Observes CanvasUnhighlightEvent event) {
        this.unhighLight();
    }

    private void setInvalidCursor() {
        this.setCursor(AbstractCanvas.Cursors.NOT_ALLOWED);
    }

    private void setValidCursor() {
        this.setCursor(AbstractCanvas.Cursors.DEFAULT);
    }

    private void setCursor(AbstractCanvas.Cursors cursor) {
        if (null != this.getCanvas()) {
            this.getCanvas().getView().setCursor(cursor);
        }
    }

    private Shape getShape(String uuid) {
        return null != this.getCanvas() ? this.getCanvas().getShape(uuid) : null;
    }

    private AbstractCanvas getCanvas() {
        return null != this.canvasHandler ? this.canvasHandler.getAbstractCanvas() : null;
    }
}

