/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import java.util.ArrayList;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.ClientFactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandAllowedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandUndoneEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.QueueGraphExecutionContext;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CommandManagerImpl;
import org.kie.workbench.common.stunner.core.graph.Element;

@Dependent
public class CanvasCommandManagerImpl<H extends AbstractCanvasHandler>
implements CanvasCommandManager<H> {
    private final ClientFactoryManager clientFactoryManager;
    private final Event<CanvasCommandAllowedEvent> isCanvasCommandAllowedEvent;
    private final Event<CanvasCommandExecutedEvent> canvasCommandExecutedEvent;
    private final Event<CanvasCommandUndoneEvent> canvasUndoCommandExecutedEvent;
    private final CommandManager<H, CanvasViolation> commandManager;

    protected CanvasCommandManagerImpl() {
        this(null, null, null, null);
    }

    @Inject
    public CanvasCommandManagerImpl(ClientFactoryManager clientFactoryManager, Event<CanvasCommandAllowedEvent> isCanvasCommandAllowedEvent, Event<CanvasCommandExecutedEvent> canvasCommandExecutedEvent, Event<CanvasCommandUndoneEvent> canvasUndoCommandExecutedEvent) {
        this.clientFactoryManager = clientFactoryManager;
        this.isCanvasCommandAllowedEvent = isCanvasCommandAllowedEvent;
        this.canvasCommandExecutedEvent = canvasCommandExecutedEvent;
        this.canvasUndoCommandExecutedEvent = canvasUndoCommandExecutedEvent;
        this.commandManager = new CommandManagerImpl();
    }

    public CommandResult<CanvasViolation> allow(H context, Command<H, CanvasViolation> command) {
        return this.runInContext((AbstractCanvasHandler)context, () -> this.postAllow(context, command, (CommandResult<CanvasViolation>)this.commandManager.allow((Object)context, command)));
    }

    public CommandResult<CanvasViolation> execute(H context, Command<H, CanvasViolation> command) {
        return this.runInContext((AbstractCanvasHandler)context, () -> this.postExecute(context, command, (CommandResult<CanvasViolation>)this.commandManager.execute((Object)context, command)));
    }

    public CommandResult<CanvasViolation> undo(H context, Command<H, CanvasViolation> command) {
        return this.runInContext((AbstractCanvasHandler)context, () -> this.postUndo(context, command, (CommandResult<CanvasViolation>)this.commandManager.undo((Object)context, command)));
    }

    private CommandResult<CanvasViolation> runInContext(AbstractCanvasHandler context, Supplier<CommandResult<CanvasViolation>> function) {
        ArrayList<Element> queue = new ArrayList<Element>();
        ArrayList contextsCreated = new ArrayList();
        context.setGraphExecutionContext(() -> {
            QueueGraphExecutionContext queueGraphExecutionContext2 = this.newQueueGraphExecutionContext(context);
            contextsCreated.add(queueGraphExecutionContext2);
            return queueGraphExecutionContext2;
        });
        CommandResult<CanvasViolation> result = function.get();
        boolean multipleSubqueues = false;
        for (QueueGraphExecutionContext contexts : contextsCreated) {
            if (!queue.isEmpty()) {
                multipleSubqueues = true;
                break;
            }
            queue.addAll(contexts.getUpdatedElements());
        }
        if (!queue.isEmpty() && !multipleSubqueues) {
            context.doBatchUpdate(queue);
        }
        for (QueueGraphExecutionContext contexts : contextsCreated) {
            contexts.resetUpdatedElements();
            contexts.clear();
        }
        context.setGraphExecutionContext(() -> null);
        return result;
    }

    public QueueGraphExecutionContext newQueueGraphExecutionContext(AbstractCanvasHandler context) {
        return new QueueGraphExecutionContext(context.getDefinitionManager(), this.clientFactoryManager, context.getRuleManager(), context.getGraphIndex(), context.getRuleSet());
    }

    private CommandResult<CanvasViolation> postAllow(H context, Command<H, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        if (null != result && null != this.isCanvasCommandAllowedEvent) {
            this.isCanvasCommandAllowedEvent.fire((Object)new CanvasCommandAllowedEvent(context, command, result));
        }
        return result;
    }

    private CommandResult<CanvasViolation> postExecute(H context, Command<H, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        if (null != result && null != this.canvasCommandExecutedEvent) {
            this.canvasCommandExecutedEvent.fire((Object)new CanvasCommandExecutedEvent(context, command, result));
        }
        return result;
    }

    private CommandResult<CanvasViolation> postUndo(H context, Command<H, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        if (null != this.canvasUndoCommandExecutedEvent) {
            this.canvasUndoCommandExecutedEvent.fire((Object)new CanvasCommandUndoneEvent(context, command, result));
        }
        return result;
    }
}

