/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public abstract class AbstractToolboxAction
implements ToolboxAction<AbstractCanvasHandler> {
    private final DefinitionUtils definitionUtils;
    private final ClientTranslationService translationService;

    protected AbstractToolboxAction(DefinitionUtils definitionUtils, ClientTranslationService translationService) {
        this.definitionUtils = definitionUtils;
        this.translationService = translationService;
    }

    protected abstract String getTitleKey(AbstractCanvasHandler var1, String var2);

    protected abstract String getTitleDefinitionId(AbstractCanvasHandler var1, String var2);

    protected abstract String getGlyphId(AbstractCanvasHandler var1, String var2);

    @Override
    public String getTitle(AbstractCanvasHandler canvasHandler, String uuid) {
        String titleKey = this.getTitleKey(canvasHandler, uuid);
        String titleDefinitionId = this.getTitleDefinitionId(canvasHandler, uuid);
        return this.translationService.getValue(titleKey) + " " + this.definitionUtils.getTitle(titleDefinitionId);
    }

    protected DefinitionUtils getDefinitionUtils() {
        return this.definitionUtils;
    }

    @Override
    public Glyph getGlyph(AbstractCanvasHandler canvasHandler, String uuid) {
        String ssid = canvasHandler.getDiagram().getMetadata().getShapeSetId();
        ShapeFactory<Object, Shape> shapeFactory = canvasHandler.getShapeFactory(ssid);
        return shapeFactory.getGlyph(this.getGlyphId(canvasHandler, uuid), ToolboxGlyphConsumer.class);
    }

    public static interface ToolboxGlyphConsumer
    extends ShapeFactory.GlyphConsumer {
    }
}

