/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.ClientFactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.components.proxies.ConnectorProxy;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.IsToolboxActionDraggable;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.shape.view.event.AbstractMouseEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseMoveEvent;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.UUID;

@Dependent
@Default
public class CreateConnectorToolboxAction
extends AbstractToolboxAction
implements IsToolboxActionDraggable<AbstractCanvasHandler> {
    static final String KEY_TITLE = "org.kie.workbench.common.stunner.core.client.toolbox.createNewConnector";
    private final ClientFactoryManager clientFactoryManager;
    private final ConnectorProxy connectorProxy;
    private String edgeId;

    @Inject
    public CreateConnectorToolboxAction(DefinitionUtils definitionUtils, ClientFactoryManager clientFactoryManager, ClientTranslationService translationService, ConnectorProxy connectorProxy) {
        super(definitionUtils, translationService);
        this.clientFactoryManager = clientFactoryManager;
        this.connectorProxy = connectorProxy;
    }

    public CreateConnectorToolboxAction setEdgeId(String edgeId) {
        this.edgeId = edgeId;
        return this;
    }

    public String getEdgeId() {
        return this.edgeId;
    }

    @Override
    public ToolboxAction<AbstractCanvasHandler> onMouseClick(AbstractCanvasHandler canvasHandler, String uuid, MouseClickEvent event) {
        this.runProxy(canvasHandler, uuid, (AbstractMouseEvent)event);
        return this;
    }

    @Override
    public ToolboxAction<AbstractCanvasHandler> onMoveStart(AbstractCanvasHandler canvasHandler, String uuid, MouseMoveEvent event) {
        this.runProxy(canvasHandler, uuid, (AbstractMouseEvent)event);
        return this;
    }

    private void runProxy(AbstractCanvasHandler canvasHandler, String uuid, AbstractMouseEvent event) {
        Element<? extends Definition<?>> sourceElement = CanvasLayoutUtils.getElement(canvasHandler, uuid);
        Node sourceNode = sourceElement.asNode();
        Edge connector = this.clientFactoryManager.newElement(UUID.uuid(), this.edgeId).asEdge();
        this.connectorProxy.setEdge(connector).setSourceNode(sourceNode).setCanvasHandler(canvasHandler).start(event);
    }

    @Override
    protected String getTitleKey(AbstractCanvasHandler canvasHandler, String uuid) {
        return KEY_TITLE;
    }

    @Override
    protected String getTitleDefinitionId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.edgeId;
    }

    @Override
    protected String getGlyphId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.edgeId;
    }

    @PreDestroy
    public void destroy() {
        this.connectorProxy.destroy();
        this.edgeId = null;
    }

    public int hashCode() {
        return this.edgeId.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof CreateConnectorToolboxAction) {
            CreateConnectorToolboxAction other = (CreateConnectorToolboxAction)o;
            return other.edgeId.equals(this.edgeId);
        }
        return false;
    }
}

