/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateConnectorToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateNodeToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.FlowActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxDomainLookups;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.lookup.domain.CommonDomainLookups;
import org.kie.workbench.common.stunner.core.profile.DomainProfileManager;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
@FlowActionsToolbox
public class FlowActionsToolboxFactory
extends AbstractActionsToolboxFactory {
    private final DefinitionUtils definitionUtils;
    private final ToolboxDomainLookups toolboxDomainLookups;
    private final DomainProfileManager profileManager;
    private final ManagedInstance<CreateConnectorToolboxAction> createConnectorActions;
    private final ManagedInstance<CreateNodeToolboxAction> createNodeActions;
    private final ManagedInstance<ActionsToolboxView> views;

    @Inject
    public FlowActionsToolboxFactory(DefinitionUtils definitionUtils, ToolboxDomainLookups toolboxDomainLookups, DomainProfileManager profileManager, @Any ManagedInstance<CreateConnectorToolboxAction> createConnectorActions, @Any @FlowActionsToolbox ManagedInstance<CreateNodeToolboxAction> createNodeActions, @Any @FlowActionsToolbox ManagedInstance<ActionsToolboxView> views) {
        this.definitionUtils = definitionUtils;
        this.toolboxDomainLookups = toolboxDomainLookups;
        this.profileManager = profileManager;
        this.createConnectorActions = createConnectorActions;
        this.createNodeActions = createNodeActions;
        this.views = views;
    }

    @Override
    protected ActionsToolboxView<?> newViewInstance() {
        return (ActionsToolboxView)this.views.get();
    }

    @Override
    public Collection<ToolboxAction<AbstractCanvasHandler>> getActions(AbstractCanvasHandler canvasHandler, Element<?> element) {
        Diagram diagram = canvasHandler.getDiagram();
        Metadata metadata = diagram.getMetadata();
        String defSetId = metadata.getDefinitionSetId();
        Annotation qualifier = this.definitionUtils.getQualifier(defSetId);
        Node node = (Node)element;
        CommonDomainLookups lookup = this.toolboxDomainLookups.get(defSetId);
        Set targetConnectors = lookup.lookupTargetConnectors(node);
        return Stream.concat(targetConnectors.stream().map(connectorDefId -> this.newCreateConnectorToolboxAction(qualifier).setEdgeId((String)connectorDefId)), targetConnectors.stream().flatMap(defaultConnectorId -> {
            Predicate definitionsAllowedFilter = this.profileManager.isDefinitionIdAllowed(metadata);
            Set targets = lookup.lookupTargetNodes(diagram.getGraph(), node, defaultConnectorId, definitionsAllowedFilter);
            Set morphTargets = lookup.lookupMorphBaseDefinitions(targets);
            return morphTargets.stream().map(defId -> this.newCreateNodeToolboxAction(qualifier).setEdgeId((String)defaultConnectorId).setNodeId((String)defId));
        })).collect(Collectors.toList());
    }

    private CreateConnectorToolboxAction newCreateConnectorToolboxAction(Annotation qualifier) {
        return InstanceUtils.lookup(this.createConnectorActions, qualifier);
    }

    private CreateNodeToolboxAction newCreateNodeToolboxAction(Annotation qualifier) {
        return InstanceUtils.lookup(this.createNodeActions, qualifier);
    }

    @PreDestroy
    public void destroy() {
        this.createConnectorActions.destroyAll();
        this.createNodeActions.destroyAll();
        this.views.destroyAll();
    }
}

