/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.view;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeViewDef;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class ShapeViewHandlersDef<W, V extends ShapeView, D extends ShapeViewDef<W, V>>
implements ShapeViewDef<W, V> {
    private final D delegate;
    private final BiConsumer<String, V> titleHandler;
    private final BiConsumer<View<W>, V> sizeHandler;
    private final BiConsumer<W, V> fontHandler;
    private final BiConsumer<W, V> viewHandler;

    public ShapeViewHandlersDef(D delegate) {
        this.delegate = delegate;
        this.titleHandler = delegate.titleHandler().orElse(null);
        this.fontHandler = delegate.fontHandler().orElse(null);
        this.sizeHandler = delegate.sizeHandler().orElse(null);
        this.viewHandler = delegate.viewHandler();
    }

    public Optional<BiConsumer<String, V>> titleHandler() {
        return Optional.ofNullable(this.titleHandler);
    }

    public Optional<BiConsumer<W, V>> fontHandler() {
        return Optional.ofNullable(this.fontHandler);
    }

    public Optional<BiConsumer<View<W>, V>> sizeHandler() {
        return Optional.ofNullable(this.sizeHandler);
    }

    public BiConsumer<W, V> viewHandler() {
        return this.viewHandler;
    }

    public Class<? extends ShapeDef> getType() {
        return this.delegate.getType();
    }

    public Glyph getGlyph(Class<? extends W> type, String defId) {
        return this.delegate.getGlyph(type, defId);
    }

    public D getShapeViewDef() {
        return this.delegate;
    }
}

