/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasPanel;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasSettings;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.uberfire.client.workbench.widgets.listbar.ResizeFlowPanel;

public abstract class AbstractCanvasView<V extends AbstractCanvasView>
extends Composite
implements AbstractCanvas.CanvasView<V>,
ProvidesResize,
RequiresResize {
    public static final String CURSOR = "cursor";
    public static final String CURSOR_NOT_ALLOWED = "not-allowed";
    private final ResizeFlowPanel mainPanel = new ResizeFlowPanel();
    private CanvasPanel canvasPanel;

    protected abstract V doInitialize(CanvasSettings var1);

    protected abstract void doDestroy();

    @PostConstruct
    public void init() {
        this.initWidget((Widget)this.mainPanel);
        this.mainPanel.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        this.mainPanel.getElement().getStyle().setHeight(100.0, Style.Unit.PCT);
    }

    @Override
    public final V initialize(CanvasPanel canvasPanel, CanvasSettings canvasSettings) {
        this.canvasPanel = canvasPanel;
        this.doInitialize(canvasSettings);
        this.mainPanel.add((IsWidget)canvasPanel);
        return this.cast();
    }

    public void onResize() {
        this.mainPanel.onResize();
    }

    @Override
    public V setCursor(AbstractCanvas.Cursors cursor) {
        if (AbstractCanvas.Cursors.NOT_ALLOWED.equals((Object)cursor)) {
            Style style = this.canvasPanel.asWidget().getElement().getStyle();
            style.setProperty(CURSOR, CURSOR_NOT_ALLOWED);
        } else {
            this.setViewCursor(cursor);
        }
        return this.cast();
    }

    protected void setViewCursor(AbstractCanvas.Cursors cursor) {
        Style style = this.canvasPanel.asWidget().getElement().getStyle();
        style.setCursor(AbstractCanvasView.toViewCursor(cursor));
    }

    @Override
    public Point2D getAbsoluteLocation() {
        return new Point2D((double)this.getAbsoluteLeft(), (double)this.getAbsoluteTop());
    }

    @Override
    public CanvasPanel getPanel() {
        return this.canvasPanel;
    }

    @Override
    public final void destroy() {
        this.doDestroy();
        this.canvasPanel.destroy();
        this.mainPanel.clear();
        this.canvasPanel = null;
    }

    public static Style.Cursor toViewCursor(AbstractCanvas.Cursors cursor) {
        switch (cursor) {
            case DEFAULT: {
                return Style.Cursor.DEFAULT;
            }
            case AUTO: {
                return Style.Cursor.AUTO;
            }
            case MOVE: {
                return Style.Cursor.MOVE;
            }
            case TEXT: {
                return Style.Cursor.TEXT;
            }
            case POINTER: {
                return Style.Cursor.POINTER;
            }
            case WAIT: {
                return Style.Cursor.WAIT;
            }
            case CROSSHAIR: {
                return Style.Cursor.CROSSHAIR;
            }
            case ROW_RESIZE: {
                return Style.Cursor.ROW_RESIZE;
            }
            case COL_RESIZE: {
                return Style.Cursor.COL_RESIZE;
            }
        }
        return Style.Cursor.DEFAULT;
    }

    private V cast() {
        return (V)this;
    }
}

