/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.actions;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.CanvasInPlaceTextEditorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextEditorBox;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasFocusedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.components.views.FloatingView;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextDoubleClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextDoubleClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextEnterEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextEnterHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextExitEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextExitHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.uberfire.mvp.Command;

public abstract class AbstractCanvasInPlaceTextEditorControl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements CanvasInPlaceTextEditorControl<AbstractCanvasHandler, EditorSession, Element> {
    static final int FLOATING_VIEW_TIMEOUT = 3000;
    static final double SHAPE_EDIT_ALPHA = 0.2;
    static final double SHAPE_NOT_EDIT_ALPHA = 1.0;
    private String uuid;
    private final Command hideFloatingViewOnTimeoutCommand = this::flush;

    protected abstract FloatingView<IsWidget> getFloatingView();

    protected abstract TextEditorBox<AbstractCanvasHandler, Element> getTextEditorBox();

    protected abstract Event<CanvasSelectionEvent> getCanvasSelectionEvent();

    public void bind(EditorSession session) {
        session.getKeyboardControl().addKeyShortcutCallback((KeyboardControl.KeyShortcutCallback)new KeyboardControl.KogitoKeyPress(new KeyboardEvent.Key[]{KeyboardEvent.Key.ESC}, "Edit | Hide", this::hide));
        session.getKeyboardControl().addKeyShortcutCallback(this::onKeyDownEvent);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.getTextEditorBox().initialize(this.canvasHandler, () -> {
            String idToSelect = this.uuid;
            this.hide();
            this.getCanvasSelectionEvent().fire((Object)new CanvasSelectionEvent((CanvasHandler)this.canvasHandler, idToSelect));
        });
        this.getFloatingView().hide().setHideCallback(this.hideFloatingViewOnTimeoutCommand).setTimeOut(3000).add((Object)this.wrapTextEditorBoxElement(this.getTextEditorBox().getElement()));
    }

    protected IsWidget wrapTextEditorBoxElement(HTMLElement element) {
        return ElementWrapperWidget.getWidget((HTMLElement)element);
    }

    public void register(final Element element) {
        ShapeView shapeView;
        Shape<?> shape;
        if (this.checkNotRegistered(element) && null != (shape = this.getShape(element.getUUID())) && (shapeView = shape.getShapeView()) instanceof HasEventHandlers) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shapeView;
            if (hasEventHandlers.supports(ViewEventType.TEXT_DBL_CLICK)) {
                TextDoubleClickHandler clickHandler = new TextDoubleClickHandler(){

                    public void handle(TextDoubleClickEvent event) {
                        if (!AbstractCanvasInPlaceTextEditorControl.this.allowOnlyVisualChanges(element)) {
                            AbstractCanvasInPlaceTextEditorControl.this.show(element, event.getClientX(), event.getClientY());
                        }
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.TEXT_DBL_CLICK, (ViewHandler)clickHandler);
                this.registerHandler(shape.getUUID(), (ViewHandler<?>)clickHandler);
            }
            if (hasEventHandlers.supports(ViewEventType.TEXT_ENTER)) {
                TextEnterHandler enterHandler = new TextEnterHandler(){

                    public void handle(TextEnterEvent event) {
                        AbstractCanvasInPlaceTextEditorControl.this.canvasHandler.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.TEXT);
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.TEXT_ENTER, (ViewHandler)enterHandler);
                this.registerHandler(shape.getUUID(), (ViewHandler<?>)enterHandler);
            }
            if (hasEventHandlers.supports(ViewEventType.TEXT_EXIT)) {
                TextExitHandler exitHandler = new TextExitHandler(){

                    public void handle(TextExitEvent event) {
                        AbstractCanvasInPlaceTextEditorControl.this.canvasHandler.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.DEFAULT);
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.TEXT_EXIT, (ViewHandler)exitHandler);
                this.registerHandler(shape.getUUID(), (ViewHandler<?>)exitHandler);
            }
        }
    }

    boolean allowOnlyVisualChanges(Element element) {
        Definition definition;
        if (element.getContent() instanceof Definition && (definition = (Definition)element.getContent()).getDefinition() instanceof DynamicReadOnly) {
            return ((DynamicReadOnly)definition.getDefinition()).isAllowOnlyVisualChange();
        }
        return false;
    }

    public CanvasInPlaceTextEditorControl<AbstractCanvasHandler, EditorSession, Element> show(Element item, double x, double y) {
        if (this.getTextEditorBox().isVisible()) {
            this.flush();
        }
        this.uuid = item.getUUID();
        this.enableShapeEdit();
        this.getTextEditorBox().show(item);
        double offsetX = this.getTextEditorBox().getDisplayOffsetX();
        double offsetY = this.getTextEditorBox().getDisplayOffsetY();
        this.getFloatingView().setX(x).setY(y).setOffsetX(-offsetX).setOffsetY(-offsetY).show();
        return this;
    }

    public CanvasInPlaceTextEditorControl<AbstractCanvasHandler, EditorSession, Element> hide() {
        if (this.isVisible()) {
            this.disableShapeEdit();
            this.uuid = null;
            this.getTextEditorBox().hide();
            this.getFloatingView().hide();
        }
        return this;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.getTextEditorBox().setCommandManagerProvider(provider);
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
        this.getTextEditorBox().hide();
        this.disableShapeEdit();
        this.getFloatingView().destroy();
        this.uuid = null;
    }

    private boolean enableShapeEdit() {
        return this.setShapeEditMode(true);
    }

    private boolean disableShapeEdit() {
        return this.setShapeEditMode(false);
    }

    private boolean setShapeEditMode(boolean editMode) {
        Shape<?> shape = this.getShape(this.uuid);
        if (null != shape) {
            HasTitle hasTitle = (HasTitle)shape.getShapeView();
            double alpha = editMode ? 0.2 : 1.0;
            shape.getShapeView().setFillAlpha(alpha);
            hasTitle.setTitleAlpha(alpha);
            return true;
        }
        return false;
    }

    private Shape<?> getShape(String uuid) {
        return null != uuid ? this.getCanvas().getShape(uuid) : null;
    }

    private boolean isVisible() {
        return null != this.uuid;
    }

    private Canvas getCanvas() {
        return this.canvasHandler.getCanvas();
    }

    void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.ESC)) {
            this.hide();
        }
    }

    void onCanvasClearSelectionEvent(@Observes CanvasClearSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.flush();
    }

    void onCanvasShapeRemovedEvent(@Observes CanvasShapeRemovedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.flush();
    }

    void onCanvasFocusedEvent(@Observes CanvasFocusedEvent canvasFocusedEvent) {
        PortablePreconditions.checkNotNull((String)"canvasFocusedEvent", (Object)canvasFocusedEvent);
        this.flush();
    }

    void onCanvasSelectionEvent(@Observes CanvasSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.flush();
    }

    void flush() {
        this.getTextEditorBox().flush();
        this.hide();
    }
}

