/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard;

import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyEventHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;

@Dependent
@Default
public class KeyboardControlImpl
extends AbstractCanvasControl<AbstractCanvas>
implements KeyboardControl<AbstractCanvas, ClientSession> {
    private final SessionManager clientSessionManager;
    private final KeyEventHandler keyEventHandler;
    private ClientSession session;

    @Inject
    public KeyboardControlImpl(SessionManager clientSessionManager, KeyEventHandler keyEventHandler) {
        this.clientSessionManager = clientSessionManager;
        this.keyEventHandler = keyEventHandler;
    }

    public KeyboardControl<AbstractCanvas, ClientSession> addKeyShortcutCallback(KeyboardControl.KeyShortcutCallback shortcutCallback) {
        this.keyEventHandler.addKeyShortcutCallback(new SessionKeyShortcutCallback(shortcutCallback));
        return this;
    }

    @Override
    protected void doInit() {
        this.keyEventHandler.setEnabled(true);
    }

    @Override
    protected void doDestroy() {
        this.keyEventHandler.setEnabled(false);
        this.keyEventHandler.clear();
        this.session = null;
    }

    public void bind(ClientSession session) {
        this.session = session;
    }

    private boolean isSameSession(ClientSession session) {
        return null != session && session.equals(this.clientSessionManager.getCurrentSession());
    }

    public class SessionKeyShortcutCallback
    implements KeyboardControl.KeyShortcutCallback {
        private final KeyboardControl.KeyShortcutCallback delegate;

        private SessionKeyShortcutCallback(KeyboardControl.KeyShortcutCallback delegate) {
            this.delegate = delegate;
        }

        public void onKeyShortcut(KeyboardEvent.Key ... keys) {
            if (KeyboardControlImpl.this.isSameSession(KeyboardControlImpl.this.session)) {
                this.delegate.onKeyShortcut(keys);
            }
        }

        public void onKeyUp(KeyboardEvent.Key key) {
            if (KeyboardControlImpl.this.isSameSession(KeyboardControlImpl.this.session)) {
                this.delegate.onKeyUp(key);
            }
        }

        public KeyboardControl.KeyShortcutCallback getDelegate() {
            return this.delegate;
        }
    }
}

