/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.select;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.MapSelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.graph.Element;

public abstract class AbstractSelectionControl<H extends AbstractCanvasHandler>
implements SelectionControl<H, Element>,
CanvasRegistrationControl<H, Element>,
CanvasControl.SessionAware<ClientSession> {
    private final Event<CanvasSelectionEvent> canvasSelectionEvent;
    private Event<CanvasClearSelectionEvent> canvasClearSelectionEvent;
    private final MapSelectionControl<H> selectionControl;

    @Inject
    public AbstractSelectionControl(Event<CanvasSelectionEvent> canvasSelectionEvent, Event<CanvasClearSelectionEvent> clearSelectionEvent) {
        this.canvasSelectionEvent = canvasSelectionEvent;
        this.canvasClearSelectionEvent = clearSelectionEvent;
        this.selectionControl = MapSelectionControl.build(this::fireSelectionEvent, this::fireClearSelectionEvent);
    }

    protected AbstractSelectionControl(MapSelectionControl<H> selectionControl, Event<CanvasSelectionEvent> canvasSelectionEvent, Event<CanvasClearSelectionEvent> clearSelectionEvent) {
        this.selectionControl = selectionControl;
        this.canvasSelectionEvent = canvasSelectionEvent;
        this.canvasClearSelectionEvent = clearSelectionEvent;
    }

    public final void init(H canvasHandler) {
        this.selectionControl.init(canvasHandler);
        this.onEnable(canvasHandler);
    }

    protected void onEnable(H canvasHandler) {
    }

    public final void register(Element element) {
        this.selectionControl.register(element);
        this.onRegister(element);
    }

    protected void onRegister(Element element) {
    }

    public final void deregister(Element element) {
        this.selectionControl.deregister(element);
        this.onDeregister(element);
    }

    protected void onDeregister(Element element) {
    }

    public SelectionControl<H, Element> select(String uuid) {
        this.selectionControl.select(uuid);
        this.onSelect(Collections.singletonList(uuid));
        return this;
    }

    protected void onSelect(Collection<String> uuids) {
    }

    public SelectionControl<H, Element> deselect(String uuid) {
        this.selectionControl.deselect(uuid);
        return this;
    }

    public boolean isSelected(Element element) {
        return this.selectionControl.isSelected(element);
    }

    public Collection<String> getSelectedItems() {
        return this.selectionControl.getSelectedItems();
    }

    public final SelectionControl<H, Element> clearSelection() {
        this.selectionControl.clearSelection();
        this.onClearSelection();
        return this;
    }

    protected void onClearSelection() {
    }

    public Optional<Object> getSelectedItemDefinition() {
        if (null != this.selectionControl) {
            return this.selectionControl.getSelectedItemDefinition();
        }
        return Optional.empty();
    }

    public void clear() {
        this.clearSelection();
    }

    public void destroy() {
        this.onDestroy();
        this.selectionControl.destroy();
    }

    protected void onDestroy() {
    }

    void onShapeRemovedEvent(@Observes CanvasShapeRemovedEvent shapeRemovedEvent) {
        PortablePreconditions.checkNotNull((String)"event", (Object)shapeRemovedEvent);
        this.handleShapeRemovedEvent(shapeRemovedEvent);
    }

    void onCanvasElementSelectedEvent(@Observes CanvasSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.handleCanvasElementSelectedEvent(event);
    }

    void onCanvasClearSelectionEvent(@Observes CanvasClearSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.handleCanvasClearSelectionEvent(event);
    }

    protected void handleShapeRemovedEvent(CanvasShapeRemovedEvent shapeRemovedEvent) {
        this.selectionControl.onShapeRemoved(shapeRemovedEvent);
    }

    protected void handleCanvasElementSelectedEvent(CanvasSelectionEvent event) {
        this.selectionControl.onCanvasElementSelected(event);
    }

    protected void handleCanvasClearSelectionEvent(CanvasClearSelectionEvent event) {
        this.selectionControl.onCanvasClearSelection(event);
    }

    public void bind(ClientSession session) {
        if (session instanceof EditorSession) {
            ((EditorSession)session).getKeyboardControl().addKeyShortcutCallback(this::onKeyDownEvent);
            ((EditorSession)session).getKeyboardControl().addKeyShortcutCallback((KeyboardControl.KeyShortcutCallback)new KeyboardControl.KogitoKeyPress(new KeyboardEvent.Key[]{KeyboardEvent.Key.ESC}, "Edit | Unselect", this::clearSelection));
            this.selectionControl.setReadonly(false);
        }
    }

    protected MapSelectionControl<H> getSelectionControl() {
        return this.selectionControl;
    }

    private void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.ESC)) {
            this.clearSelection();
        }
    }

    private void fireSelectionEvent(CanvasSelectionEvent e) {
        this.canvasSelectionEvent.fire((Object)e);
        this.onSelect(e.getIdentifiers());
    }

    private void fireClearSelectionEvent(CanvasClearSelectionEvent e) {
        this.canvasClearSelectionEvent.fire((Object)e);
        this.onClearSelection();
    }

    public static Collection<String> shapesToIdentifiers(Collection<?> shapes) {
        return shapes.stream().filter(shape -> shape instanceof ShapeView).map(shape -> ((ShapeView)shape).getUUID()).collect(Collectors.toList());
    }
}

