/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import java.util.ArrayList;
import java.util.Stack;
import java.util.function.Consumer;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.CommandRequestLifecycle;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;

public class RequestCommands
implements CommandRequestLifecycle {
    private final Consumer<Command<AbstractCanvasHandler, CanvasViolation>> completedCommand;
    private final Consumer<Command<AbstractCanvasHandler, CanvasViolation>> rollbackCommand;
    private Stack<Command<AbstractCanvasHandler, CanvasViolation>> commands;
    private boolean rollback;

    RequestCommands(Consumer<Command<AbstractCanvasHandler, CanvasViolation>> completedCommand, Consumer<Command<AbstractCanvasHandler, CanvasViolation>> rollbackCommand) {
        this.completedCommand = completedCommand;
        this.rollbackCommand = rollbackCommand;
    }

    public void start() {
        this.commands = new Stack();
        this.rollback = false;
    }

    public void push(Command<AbstractCanvasHandler, CanvasViolation> command) {
        this.commands.push(command);
    }

    boolean isStarted() {
        return null != this.commands;
    }

    public void rollback() {
        this.rollback = true;
    }

    public void complete() {
        if (null != this.commands && !this.commands.isEmpty()) {
            CompositeCommand composite = new CompositeCommand.Builder().reverse().addCommands(new ArrayList<Command<AbstractCanvasHandler, CanvasViolation>>(this.commands)).build();
            if (this.rollback) {
                this.rollbackCommand.accept((Command<AbstractCanvasHandler, CanvasViolation>)composite);
            } else {
                this.completedCommand.accept((Command<AbstractCanvasHandler, CanvasViolation>)composite);
            }
        }
        this.clear();
    }

    void clear() {
        if (null != this.commands) {
            this.commands.clear();
            this.commands = null;
        }
        this.rollback = false;
    }

    public static class Builder {
        private Consumer<Command<AbstractCanvasHandler, CanvasViolation>> completedCommand;
        private Consumer<Command<AbstractCanvasHandler, CanvasViolation>> rollbackCommand;

        public Builder onComplete(Consumer<Command<AbstractCanvasHandler, CanvasViolation>> consumer) {
            this.completedCommand = consumer;
            return this;
        }

        public Builder onRollback(Consumer<Command<AbstractCanvasHandler, CanvasViolation>> consumer) {
            this.rollbackCommand = consumer;
            return this;
        }

        public RequestCommands build() {
            return new RequestCommands(this.completedCommand, this.rollbackCommand);
        }
    }
}

