/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.proxies;

import com.google.gwt.user.client.Timer;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.command.DefaultCanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.proxies.ShapeProxy;
import org.kie.workbench.common.stunner.core.client.components.proxies.ShapeProxyView;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.client.shape.ElementShape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
public class ElementProxy
implements ShapeProxy {
    private final SessionCommandManager<AbstractCanvasHandler> commandManager;
    private final Event<CanvasSelectionEvent> selectionEvent;
    private final ManagedInstance<DefaultCanvasCommandFactory> commandFactories;
    private final DefinitionUtils definitionUtils;
    private AbstractCanvasHandler canvasHandler;
    private ShapeProxyView<ElementShape> view;
    private Supplier<ElementShape> proxyBuilder;

    @Inject
    public ElementProxy(SessionCommandManager<AbstractCanvasHandler> commandManager, Event<CanvasSelectionEvent> selectionEvent, @Any ManagedInstance<DefaultCanvasCommandFactory> commandFactories, DefinitionUtils definitionUtils) {
        this.commandManager = commandManager;
        this.selectionEvent = selectionEvent;
        this.commandFactories = commandFactories;
        this.definitionUtils = definitionUtils;
    }

    public ElementProxy setView(ShapeProxyView<? extends ElementShape> view) {
        this.view = view;
        return this;
    }

    public ElementProxy setProxyBuilder(Supplier<ElementShape> proxyBuilder) {
        this.proxyBuilder = proxyBuilder;
        return this;
    }

    public ElementProxy setCanvasHandler(AbstractCanvasHandler canvasHandler) {
        this.canvasHandler = canvasHandler;
        return this;
    }

    @Override
    public void start(double x, double y) {
        this.view.onCreate(this::createProxy).onAccept(this::acceptProxy).onDestroy(this::destroyProxy).setCanvas(this.getCanvas()).start(x, y);
    }

    @Override
    public void destroy() {
        if (null != this.view) {
            this.view.destroy();
        }
        this.commandFactories.destroyAll();
        this.canvasHandler = null;
        this.view = null;
        this.proxyBuilder = null;
    }

    public CommandResult<CanvasViolation> execute(Command<AbstractCanvasHandler, CanvasViolation> command) {
        return this.commandManager.execute((Object)this.canvasHandler, command);
    }

    void handleCancelKey(KeyboardEvent.Key key) {
        if (KeyboardEvent.Key.ESC == key) {
            this.destroy();
        }
    }

    public Canvas getCanvas() {
        return this.canvasHandler.getCanvas();
    }

    public AbstractCanvasHandler getCanvasHandler() {
        return this.canvasHandler;
    }

    private ElementShape createProxy() {
        this.commandManager.start();
        ElementShape instance = this.proxyBuilder.get();
        instance.applyState(ShapeState.SELECTED);
        return instance;
    }

    private void acceptProxy(ElementShape shape) {
        this.commandManager.complete();
        this.select(shape.getUUID());
    }

    void select(final String uuid) {
        Timer t = new Timer(){

            public void run() {
                CanvasLayoutUtils.fireElementSelectedEvent((Event<CanvasSelectionEvent>)ElementProxy.this.selectionEvent, ElementProxy.this.canvasHandler, uuid);
            }
        };
        t.schedule(150);
    }

    private void destroyProxy(ElementShape shape) {
        this.commandManager.rollback();
        this.commandManager.complete();
    }

    CanvasCommandFactory<AbstractCanvasHandler> lookupCanvasFactory() {
        Diagram diagram = this.getCanvasHandler().getDiagram();
        String id = diagram.getMetadata().getDefinitionSetId();
        Annotation qualifier = this.definitionUtils.getQualifier(id);
        return InstanceUtils.lookup(this.commandFactories, qualifier);
    }
}

