/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.definition.adapter.binding;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.kie.workbench.common.stunner.core.client.definition.adapter.binding.AbstractClientBindableAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertySetAdapter;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

class ClientBindablePropertySetAdapter
extends AbstractClientBindableAdapter<Object>
implements BindablePropertySetAdapter<Object> {
    private Map<Class, String> propertyNameFieldNames;
    private Map<Class, Set<String>> propertiesFieldNames;

    public ClientBindablePropertySetAdapter(StunnerTranslationService translationService) {
        super(translationService);
    }

    public void setBindings(Map<Class, String> propertyNameFieldNames, Map<Class, Set<String>> propertiesFieldNames) {
        this.propertyNameFieldNames = propertyNameFieldNames;
        this.propertiesFieldNames = propertiesFieldNames;
    }

    public String getId(Object pojo) {
        return BindableAdapterUtils.getPropertySetId(pojo.getClass());
    }

    public String getName(Object pojo) {
        String name = this.translationService.getPropertySetName(pojo.getClass().getName());
        if (name != null) {
            return name;
        }
        return (String)this.getProxiedValue(pojo, this.getPropertyNameFieldNames().get(pojo.getClass()));
    }

    public Set<?> getProperties(Object pojo) {
        return this.getProxiedSet(pojo, (Collection<String>)this.getPropertiesFieldNames().get(pojo.getClass()));
    }

    public Optional<?> getProperty(Object pojo, String propertyName) {
        return this.getPropertiesFieldNames().get(pojo.getClass()).stream().filter(name -> Objects.equals(name, propertyName)).findFirst().map(prop -> this.getProxiedValue(pojo, (String)prop));
    }

    public boolean accepts(Class<?> pojoClass) {
        return this.getPropertiesFieldNames().containsKey(pojoClass);
    }

    private Map<Class, String> getPropertyNameFieldNames() {
        return this.propertyNameFieldNames;
    }

    private Map<Class, Set<String>> getPropertiesFieldNames() {
        return this.propertiesFieldNames;
    }
}

