/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.Collection;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementsClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.AbstractSelectionAwareSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.SessionSingletonCommandsFactory;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
@Default
public class DeleteSelectionSessionCommand
extends AbstractSelectionAwareSessionCommand<EditorSession> {
    private static Logger LOGGER = Logger.getLogger(DeleteSelectionSessionCommand.class.getName());
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final ManagedInstance<CanvasCommandFactory<AbstractCanvasHandler>> canvasCommandFactoryInstance;
    private final Event<CanvasClearSelectionEvent> clearSelectionEvent;
    private final DefinitionUtils definitionUtils;
    private CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;

    protected DeleteSelectionSessionCommand() {
        this(null, null, null, null, null);
    }

    @Inject
    public DeleteSelectionSessionCommand(SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, @Any ManagedInstance<CanvasCommandFactory<AbstractCanvasHandler>> canvasCommandFactoryInstance, Event<CanvasClearSelectionEvent> clearSelectionEvent, DefinitionUtils definitionUtils, SessionManager sessionmanager) {
        super(false);
        this.sessionCommandManager = sessionCommandManager;
        this.canvasCommandFactoryInstance = canvasCommandFactoryInstance;
        this.clearSelectionEvent = clearSelectionEvent;
        this.definitionUtils = definitionUtils;
        SessionSingletonCommandsFactory.createOrPut(this, sessionmanager);
    }

    public static DeleteSelectionSessionCommand getInstance(SessionManager sessionManager) {
        return SessionSingletonCommandsFactory.getInstanceDelete(null, null, null, null, sessionManager);
    }

    public static DeleteSelectionSessionCommand getInstance(SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, ManagedInstance<CanvasCommandFactory<AbstractCanvasHandler>> canvasCommandFactoryInstance, Event<CanvasClearSelectionEvent> clearSelectionEvent, DefinitionUtils definitionUtils, SessionManager sessionmanager) {
        return SessionSingletonCommandsFactory.getInstanceDelete(sessionCommandManager, canvasCommandFactoryInstance, clearSelectionEvent, definitionUtils, sessionmanager);
    }

    @Override
    public void bind(EditorSession session) {
        super.bind(session);
        session.getKeyboardControl().addKeyShortcutCallback((KeyboardControl.KeyShortcutCallback)new KeyboardControl.KogitoKeyPress(new KeyboardEvent.Key[]{KeyboardEvent.Key.KEY_BACKSPACE}, "Edit | Delete selection", () -> {
            if (this.isEnabled()) {
                this.execute();
            }
        }));
        session.getKeyboardControl().addKeyShortcutCallback((KeyboardControl.KeyShortcutCallback)new KeyboardControl.KogitoKeyPress(new KeyboardEvent.Key[]{KeyboardEvent.Key.DELETE}, "Edit | Delete selection", () -> {
            if (this.isEnabled()) {
                this.execute();
            }
        }));
        session.getKeyboardControl().addKeyShortcutCallback(this::onKeyDownEvent);
        this.canvasCommandFactory = this.loadCanvasFactory(this.canvasCommandFactoryInstance, this.definitionUtils);
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        if (null != this.getSession() && null != ((EditorSession)this.getSession()).getSelectionControl()) {
            AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)((EditorSession)this.getSession()).getCanvasHandler();
            SelectionControl<AbstractCanvasHandler, Element> selectionControl = ((EditorSession)this.getSession()).getSelectionControl();
            Collection selectedItems = selectionControl.getSelectedItems();
            this.clearSelectionEvent.fire((Object)new CanvasClearSelectionEvent((CanvasHandler)canvasHandler));
            selectionControl.clearSelection();
            if (selectedItems != null && !selectedItems.isEmpty()) {
                CommandResult result = this.sessionCommandManager.execute((Object)canvasHandler, (Command)this.canvasCommandFactory.delete((Collection)selectedItems.stream().map(uuid -> canvasHandler.getGraphIndex().get(uuid)).filter(Objects::nonNull).collect(Collectors.toList())));
                if (!CommandUtils.isError((CommandResult)result)) {
                    callback.onSuccess();
                } else {
                    callback.onError(new ClientRuntimeError("Error deleing elements [message=" + result.toString() + "]"));
                }
            } else {
                callback.onError(new ClientRuntimeError("Cannot delete element, no element selected on canvas"));
            }
        }
    }

    protected void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (this.isEnabled()) {
            this.handleDelete(keys);
        }
    }

    private void handleDelete(KeyboardEvent.Key ... keys) {
        if (KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.DELETE) || KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.KEY_BACKSPACE)) {
            this.execute();
        }
    }

    @Override
    protected void handleCanvasSelectionEvent(CanvasSelectionEvent event) {
        if (event.getIdentifiers().isEmpty() || this.onlyCanvasRootSelected(event)) {
            this.enable(false);
        } else {
            this.enable(true);
        }
    }

    @Override
    protected void handleCanvasClearSelectionEvent(CanvasClearSelectionEvent event) {
        this.enable(false);
    }

    @Override
    protected void handleCanvasElementsClearEvent(CanvasElementsClearEvent event) {
        this.enable(false);
    }
}

