/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.event;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramOpenedHandler;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramSavedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramSavedHandler;
import org.kie.workbench.common.stunner.core.diagram.Diagram;

@ApplicationScoped
public class SessionEventObserver {
    private List<SessionDiagramOpenedHandler> sessionDiagramOpenedHandlers = new ArrayList<SessionDiagramOpenedHandler>();
    private List<SessionDiagramSavedHandler> sessionDiagramSavedHandlers = new ArrayList<SessionDiagramSavedHandler>();

    public SessionEventObserver() {
    }

    @Inject
    public SessionEventObserver(@Any Instance<SessionDiagramOpenedHandler> sessionDiagramOpenedHandlersInstance, @Any Instance<SessionDiagramSavedHandler> sessionDiagramSavedHandlersInstance) {
        sessionDiagramOpenedHandlersInstance.iterator().forEachRemaining(handler -> this.sessionDiagramOpenedHandlers.add((SessionDiagramOpenedHandler)handler));
        sessionDiagramSavedHandlersInstance.iterator().forEachRemaining(handler -> this.sessionDiagramSavedHandlers.add((SessionDiagramSavedHandler)handler));
    }

    void onSessionDiagramOpenedEvent(@Observes SessionDiagramOpenedEvent event) {
        Diagram currentDiagram = event.getSession().getCanvasHandler().getDiagram();
        this.sessionDiagramOpenedHandlers.stream().filter(handler -> handler.accepts(currentDiagram)).forEach(handler -> handler.onSessionDiagramOpened(event.getSession()));
    }

    void onSessionDiagramSavedEvent(@Observes SessionDiagramSavedEvent event) {
        Diagram currentDiagram = event.getSession().getCanvasHandler().getDiagram();
        this.sessionDiagramSavedHandlers.stream().filter(handler -> handler.accepts(currentDiagram)).forEach(handler -> handler.onSessionDiagramSaved(event.getSession()));
    }
}

