/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.inlineeditor;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.touch.client.Point;
import com.google.gwt.user.client.ui.IsWidget;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasInlineTextEditorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.inlineeditor.TextEditorBox;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.components.views.FloatingView;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextDoubleClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextDoubleClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextEnterEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextEnterHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextExitEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextExitHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

public abstract class AbstractCanvasInlineTextEditorControl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements CanvasInlineTextEditorControl<AbstractCanvasHandler, EditorSession, Element> {
    public static final double SHAPE_EDIT_ALPHA = 0.2;
    public static final double TITLE_EDIT_ALPHA = 0.0;
    public static final double NOT_EDIT_ALPHA = 1.0;
    public static final String ALIGN_MIDDLE = "MIDDLE";
    public static final String ALIGN_LEFT = "LEFT";
    public static final String ALIGN_TOP = "TOP";
    public static final String POSITION_INSIDE = "INSIDE";
    public static final String POSITION_OUTSIDE = "OUTSIDE";
    public static final String ORIENTATION_VERTICAL = "VERTICAL";
    public static final String ORIENTATION_HORIZONTAL = "HORIZONTAL";
    public static final double DEFAULT_MARGIN_X = 0.0;
    public static final double DEFAULT_FONT_SIZE = 14.0;
    public static final String DEFAULT_FONT_FAMILY = "Open Sans";
    private String uuid;
    private Point shapePosition;
    private Point shapeSize;
    private Point2D canvasPosition;
    private Point scrollBarsPosition;
    private double zoomFactor;
    private BoxType boxType;
    private HandlerRegistration mouseWheelHandler;
    private KeyboardControl<AbstractCanvas, ClientSession> keyboardControl;
    private String fontFamily;
    private double fontSize;
    private double marginX;
    protected boolean isMultiline;
    protected double borderOffsetX;
    protected double borderOffsetY;
    protected double underBoxOffset;
    protected double topBorderOffset;
    protected double fontSizeCorrection;
    protected double maxInnerLeftBoxWidth;
    protected double maxInnerLeftBoxHeight;
    protected double maxInnerTopBoxWidth;
    protected double maxInnerTopBoxHeight;
    protected double scrollBarOffset;
    protected double paletteOffsetX;
    protected double innerBoxOffsetY;

    protected abstract FloatingView<IsWidget> getFloatingView();

    protected abstract TextEditorBox<AbstractCanvasHandler, Element> getTextEditorBox();

    public void bind(EditorSession session) {
        this.keyboardControl = session.getKeyboardControl();
        this.keyboardControl.addKeyShortcutCallback((KeyboardControl.KeyShortcutCallback)new KeyboardControl.KogitoKeyPress(new KeyboardEvent.Key[]{KeyboardEvent.Key.ESC}, "Edit | Hide", this::hide));
        this.keyboardControl.addKeyShortcutCallback(this::onKeyDownEvent);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.getTextEditorBox().initialize(this.canvasHandler, () -> this.scheduleDeferredCommand(() -> this.hide()));
        this.getFloatingView().hide().add((Object)this.wrapTextEditorBoxElement(this.getTextEditorBox().getElement()));
        this.setMouseWheelHandler();
    }

    protected IsWidget wrapTextEditorBoxElement(HTMLElement element) {
        return ElementWrapperWidget.getWidget((HTMLElement)element);
    }

    public void register(Element element) {
        ShapeView shapeView;
        Shape<?> shape;
        if (this.checkNotRegistered(element) && null != (shape = this.getShape(element.getUUID())) && (shapeView = shape.getShapeView()) instanceof HasEventHandlers) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shapeView;
            if (hasEventHandlers.supports(ViewEventType.TEXT_DBL_CLICK)) {
                this.registerTextDoubleClick(shape, element, hasEventHandlers);
            }
            if (hasEventHandlers.supports(ViewEventType.TEXT_ENTER)) {
                this.changeMouseCursorOnTextEnter(shape, hasEventHandlers);
            }
            if (hasEventHandlers.supports(ViewEventType.TEXT_EXIT)) {
                this.changeMouseCursorOnTextExit(shape, hasEventHandlers);
            }
        }
    }

    private void registerTextDoubleClick(Shape<?> shape, final Element element, HasEventHandlers hasEventHandlers) {
        TextDoubleClickHandler clickHandler = new TextDoubleClickHandler(){

            public void handle(TextDoubleClickEvent event) {
                AbstractCanvasInlineTextEditorControl.this.scheduleDeferredCommand(() -> AbstractCanvasInlineTextEditorControl.this.show(element));
            }
        };
        hasEventHandlers.addHandler(ViewEventType.TEXT_DBL_CLICK, (ViewHandler)clickHandler);
        this.registerHandler(shape.getUUID(), (ViewHandler<?>)clickHandler);
    }

    private void changeMouseCursorOnTextEnter(Shape<?> shape, HasEventHandlers hasEventHandlers) {
        TextEnterHandler enterHandler = new TextEnterHandler(){

            public void handle(TextEnterEvent event) {
                AbstractCanvasInlineTextEditorControl.this.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.TEXT);
            }
        };
        hasEventHandlers.addHandler(ViewEventType.TEXT_ENTER, (ViewHandler)enterHandler);
        this.registerHandler(shape.getUUID(), (ViewHandler<?>)enterHandler);
    }

    private void changeMouseCursorOnTextExit(Shape<?> shape, HasEventHandlers hasEventHandlers) {
        TextExitHandler exitHandler = new TextExitHandler(){

            public void handle(TextExitEvent event) {
                AbstractCanvasInlineTextEditorControl.this.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.DEFAULT);
            }
        };
        hasEventHandlers.addHandler(ViewEventType.TEXT_EXIT, (ViewHandler)exitHandler);
        this.registerHandler(shape.getUUID(), (ViewHandler<?>)exitHandler);
    }

    boolean allowOnlyVisualChanges(Element element) {
        Definition definition;
        if (element.getContent() instanceof Definition && (definition = (Definition)element.getContent()).getDefinition() instanceof DynamicReadOnly) {
            return ((DynamicReadOnly)definition.getDefinition()).isAllowOnlyVisualChange();
        }
        return false;
    }

    public CanvasInlineTextEditorControl<AbstractCanvasHandler, EditorSession, Element> show(Element item) {
        double floatingViewPositionY;
        double floatingViewPositionX;
        String editorBoxAlign;
        double editorBoxHeight;
        double editorBoxWidth;
        this.setInlineBoxContext(item.getUUID());
        if (this.boxType == BoxType.INSIDE_LEFT) {
            editorBoxWidth = this.getInnerLeftBoxWidth();
            editorBoxHeight = this.getInnerLeftBoxHeight();
            editorBoxAlign = ALIGN_LEFT;
            floatingViewPositionX = this.getInnerLeftBoxPosition().getX();
            floatingViewPositionY = this.getInnerLeftBoxPosition().getY();
        } else if (this.boxType == BoxType.INSIDE_TOP) {
            editorBoxWidth = this.getInnerTopBoxWidth();
            editorBoxHeight = this.getInnerTopBoxHeight();
            editorBoxAlign = ALIGN_TOP;
            floatingViewPositionX = this.getInnerTopBoxPosition().getX();
            floatingViewPositionY = this.getInnerTopBoxPosition().getY();
        } else if (this.boxType == BoxType.OUTSIDE) {
            editorBoxWidth = this.getUnderBoxWidth();
            editorBoxHeight = this.getUnderBoxHeight();
            editorBoxAlign = ALIGN_TOP;
            floatingViewPositionX = this.getUnderBoxPosition().getX();
            floatingViewPositionY = this.getUnderBoxPosition().getY();
        } else {
            editorBoxWidth = this.getInnerBoxWidth();
            editorBoxHeight = this.getInnerBoxHeight();
            editorBoxAlign = ALIGN_MIDDLE;
            floatingViewPositionX = this.getInnerBoxPosition().getX();
            floatingViewPositionY = this.getInnerBoxPosition().getY();
        }
        if (this.isPositionXValid(floatingViewPositionX) && this.isPositionYValid(floatingViewPositionY)) {
            this.enableShapeEdit();
            this.getTextEditorBox().setFontFamily(this.fontFamily);
            this.getTextEditorBox().setFontSize((this.fontSize + this.fontSizeCorrection) * this.zoomFactor);
            this.getTextEditorBox().setTextBoxInternalAlignment(editorBoxAlign);
            this.getTextEditorBox().setMultiline(this.isMultiline);
            this.getFloatingView().setX(floatingViewPositionX);
            this.getFloatingView().setY(floatingViewPositionY);
            this.getFloatingView().clearTimeOut();
            this.getTextEditorBox().show(item, this.fixBoundaryX(editorBoxWidth, floatingViewPositionX), this.fixBoundaryY(editorBoxHeight, floatingViewPositionY));
            this.getFloatingView().show();
            this.keyboardControl.setKeyEventHandlerEnabled(false);
        }
        return this;
    }

    private boolean isPositionXValid(double floatingViewPositionX) {
        return !(this.canvasPosition.getX() + this.paletteOffsetX > floatingViewPositionX);
    }

    private boolean isPositionYValid(double floatingViewPositionY) {
        return !(floatingViewPositionY > this.getCanvasAbsoluteHeight());
    }

    private double fixBoundaryX(double editorBoxWidth, double floatingViewPositionX) {
        if (editorBoxWidth + floatingViewPositionX > this.getCanvasAbsoluteWidth()) {
            return editorBoxWidth - (editorBoxWidth + floatingViewPositionX - this.getCanvasAbsoluteWidth());
        }
        if (this.canvasPosition.getX() + this.paletteOffsetX > floatingViewPositionX) {
            return editorBoxWidth - this.paletteOffsetX - (this.canvasPosition.getX() - floatingViewPositionX);
        }
        return editorBoxWidth;
    }

    private double fixBoundaryY(double editorBoxHeight, double floatingViewPositionY) {
        if (editorBoxHeight + floatingViewPositionY > this.getCanvasAbsoluteHeight()) {
            return editorBoxHeight - (editorBoxHeight + floatingViewPositionY - this.getCanvasAbsoluteHeight());
        }
        return editorBoxHeight;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.getTextEditorBox().setCommandManagerProvider(provider);
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
        this.getTextEditorBox().hide();
        this.disableShapeEdit();
        this.getFloatingView().destroy();
        this.uuid = null;
        this.mouseWheelHandler.removeHandler();
    }

    private void enableShapeEdit() {
        this.setShapeEditMode(true);
    }

    private void disableShapeEdit() {
        this.setShapeEditMode(false);
    }

    private void setInlineBoxContext(String uuid) {
        String fontAlignment;
        String orientation;
        String titlePosition;
        this.uuid = uuid;
        HasTitle hasTitle = this.getHasTitle();
        if (null != hasTitle) {
            titlePosition = hasTitle.getTitlePosition();
            orientation = hasTitle.getOrientation();
            fontAlignment = hasTitle.getFontAlignment();
            this.marginX = hasTitle.getMarginX();
            this.fontSize = hasTitle.getTitleFontSize();
            this.fontFamily = hasTitle.getTitleFontFamily();
        } else {
            titlePosition = POSITION_INSIDE;
            orientation = ORIENTATION_HORIZONTAL;
            fontAlignment = ALIGN_MIDDLE;
            this.marginX = 0.0;
            this.fontSize = 14.0;
            this.fontFamily = DEFAULT_FONT_FAMILY;
        }
        this.shapePosition = this.getShapePosition();
        this.shapeSize = this.getShapeSize();
        this.canvasPosition = this.getCanvasAbsolutePosition();
        this.scrollBarsPosition = this.getScrollBarsPosition();
        this.zoomFactor = this.getZoomFactor();
        switch (titlePosition) {
            case "INSIDE": {
                if (orientation.equals(ORIENTATION_HORIZONTAL) && fontAlignment.equals(ALIGN_MIDDLE)) {
                    this.boxType = BoxType.INSIDE_MIDDLE;
                    break;
                }
                if (orientation.equals(ORIENTATION_HORIZONTAL) && fontAlignment.equals(ALIGN_TOP)) {
                    this.boxType = BoxType.INSIDE_TOP;
                    break;
                }
                if (!orientation.equals(ORIENTATION_VERTICAL)) break;
                this.boxType = BoxType.INSIDE_LEFT;
                break;
            }
            case "OUTSIDE": {
                this.boxType = BoxType.OUTSIDE;
                break;
            }
            default: {
                this.boxType = BoxType.INSIDE_MIDDLE;
            }
        }
    }

    private double getUnderBoxWidth() {
        return this.shapeSize.getX() * 2.0 * this.zoomFactor;
    }

    private double getUnderBoxHeight() {
        return this.shapeSize.getY() * this.zoomFactor;
    }

    private Point getUnderBoxPosition() {
        double x = (this.shapePosition.getX() - this.shapeSize.getX() / 2.0) * this.zoomFactor + this.canvasPosition.getX() + this.scrollBarsPosition.getX();
        double y = (this.shapePosition.getY() + this.shapeSize.getY() + this.underBoxOffset) * this.zoomFactor + this.canvasPosition.getY() + this.scrollBarsPosition.getY();
        return new Point(x, y);
    }

    private double getInnerBoxWidth() {
        return (this.shapeSize.getX() - this.marginX - this.borderOffsetX * 2.0) * this.zoomFactor;
    }

    private double getInnerBoxHeight() {
        return (this.shapeSize.getY() - this.borderOffsetY * 2.0) * this.zoomFactor;
    }

    private Point getInnerBoxPosition() {
        double x = (this.shapePosition.getX() + this.borderOffsetX + this.marginX) * this.zoomFactor + this.canvasPosition.getX() + this.scrollBarsPosition.getX();
        double y = (this.shapePosition.getY() + this.borderOffsetY + this.innerBoxOffsetY) * this.zoomFactor + this.canvasPosition.getY() + this.scrollBarsPosition.getY();
        return new Point(x, y);
    }

    private double getInnerLeftBoxWidth() {
        if (this.shapeSize.getX() > this.maxInnerLeftBoxWidth) {
            return this.maxInnerLeftBoxWidth * this.zoomFactor;
        }
        return this.shapeSize.getX() * this.zoomFactor;
    }

    private double getInnerLeftBoxHeight() {
        if (this.shapeSize.getY() > this.maxInnerLeftBoxHeight) {
            return this.maxInnerLeftBoxHeight * this.zoomFactor;
        }
        return this.shapeSize.getY() * this.zoomFactor;
    }

    private Point getInnerLeftBoxPosition() {
        double offsetY = (this.shapeSize.getY() * this.zoomFactor - this.getInnerLeftBoxHeight()) / 2.0;
        double x = (this.shapePosition.getX() + this.borderOffsetX) * this.zoomFactor + this.canvasPosition.getX() + this.scrollBarsPosition.getX();
        double y = this.shapePosition.getY() * this.zoomFactor + offsetY + this.canvasPosition.getY() + this.scrollBarsPosition.getY();
        return new Point(x, y);
    }

    private double getInnerTopBoxWidth() {
        if (this.shapeSize.getX() > this.maxInnerTopBoxWidth) {
            return this.maxInnerTopBoxWidth * this.zoomFactor;
        }
        return (this.shapeSize.getX() - this.borderOffsetX * 2.0) * this.zoomFactor;
    }

    private double getInnerTopBoxHeight() {
        if (this.shapeSize.getY() > this.maxInnerTopBoxHeight) {
            return this.maxInnerTopBoxHeight * this.zoomFactor;
        }
        return (this.shapeSize.getY() - this.topBorderOffset) * this.zoomFactor;
    }

    private Point getInnerTopBoxPosition() {
        double x = this.shapeSize.getX() > this.maxInnerTopBoxWidth ? (this.shapePosition.getX() + this.marginX + (this.shapeSize.getX() - this.maxInnerTopBoxWidth) / 2.0) * this.zoomFactor + this.canvasPosition.getX() + this.scrollBarsPosition.getX() : (this.shapePosition.getX() + this.borderOffsetX + this.marginX) * this.zoomFactor + this.canvasPosition.getX() + this.scrollBarsPosition.getX();
        double y = (this.shapePosition.getY() + this.topBorderOffset) * this.zoomFactor + this.canvasPosition.getY() + this.scrollBarsPosition.getY();
        return new Point(x, y);
    }

    private double getZoomFactor() {
        return this.getCanvas().getTransform().getScale().getX();
    }

    private Point getScrollBarsPosition() {
        double scrollX = this.getCanvas().getTransform().getTranslate().getX();
        double scrollY = this.getCanvas().getTransform().getTranslate().getY();
        return new Point(scrollX, scrollY);
    }

    private Point2D getCanvasAbsolutePosition() {
        return this.getAbstractCanvas().getView().getAbsoluteLocation();
    }

    private Point getShapeSize() {
        Shape<?> shape = this.getShape(this.uuid);
        double width = 0.0;
        double height = 0.0;
        if (null != shape) {
            width = shape.getShapeView().getBoundingBox().getWidth();
            height = shape.getShapeView().getBoundingBox().getHeight();
        }
        return new Point(width, height);
    }

    private Point getShapePosition() {
        Shape<?> shape = this.getShape(this.uuid);
        int x = 0;
        int y = 0;
        if (null != shape) {
            x = (int)shape.getShapeView().getShapeAbsoluteLocation().getX();
            y = (int)shape.getShapeView().getShapeAbsoluteLocation().getY();
        }
        return new Point((double)x, (double)y);
    }

    double getCanvasAbsoluteWidth() {
        return (double)this.getAbstractCanvas().getView().getPanel().asWidget().getOffsetWidth() + this.canvasPosition.getX() - this.scrollBarOffset;
    }

    double getCanvasAbsoluteHeight() {
        return (double)this.getAbstractCanvas().getView().getPanel().asWidget().getOffsetHeight() + this.canvasPosition.getY() - this.scrollBarOffset;
    }

    private boolean setShapeEditMode(boolean editMode) {
        Shape<?> shape = this.getShape(this.uuid);
        if (null != shape) {
            HasTitle hasTitle = (HasTitle)shape.getShapeView();
            double alpha = editMode ? 0.2 : 1.0;
            double titleAlpha = editMode ? 0.0 : 1.0;
            shape.getShapeView().setFillAlpha(alpha);
            hasTitle.setTitleAlpha(titleAlpha);
            return true;
        }
        return false;
    }

    private Shape<?> getShape(String uuid) {
        return null != uuid ? this.getCanvas().getShape(uuid) : null;
    }

    HasTitle getHasTitle() {
        Shape<?> shape = this.getShape(this.uuid);
        return null != shape ? (HasTitle)shape.getShapeView() : null;
    }

    private boolean isVisible() {
        return null != this.uuid;
    }

    private Canvas getCanvas() {
        return this.canvasHandler.getCanvas();
    }

    AbstractCanvas getAbstractCanvas() {
        return this.canvasHandler.getAbstractCanvas();
    }

    void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.ESC)) {
            this.rollback();
        }
    }

    void setMouseWheelHandler() {
        this.mouseWheelHandler = this.getAbstractCanvas().getView().getPanel().asWidget().addDomHandler((EventHandler)((MouseWheelHandler)this::onMouseWheel), MouseWheelEvent.getType());
    }

    void onMouseWheel(MouseWheelEvent event) {
        this.rollback();
    }

    public CanvasInlineTextEditorControl<AbstractCanvasHandler, EditorSession, Element> rollback() {
        if (this.isVisible()) {
            this.getTextEditorBox().rollback();
        }
        this.keyboardControl.setKeyEventHandlerEnabled(true);
        return this;
    }

    public CanvasInlineTextEditorControl<AbstractCanvasHandler, EditorSession, Element> hide() {
        if (this.isVisible()) {
            this.disableShapeEdit();
            this.uuid = null;
            this.getTextEditorBox().hide();
            this.getFloatingView().hide();
        }
        this.keyboardControl.setKeyEventHandlerEnabled(true);
        return this;
    }

    public void scheduleDeferredCommand(Scheduler.ScheduledCommand command) {
        Scheduler.get().scheduleDeferred(command);
    }

    private static enum BoxType {
        OUTSIDE,
        INSIDE_MIDDLE,
        INSIDE_LEFT,
        INSIDE_TOP;

    }
}

