/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.shortcut;

import java.util.Set;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.shortcut.KeyboardShortcut;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.GeneralCreateNodeAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxDomainLookups;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.lookup.domain.CommonDomainLookups;
import org.kie.workbench.common.stunner.core.registry.impl.DefinitionsCacheRegistry;

public abstract class AbstractAppendNodeShortcut
implements KeyboardShortcut<AbstractCanvasHandler> {
    private ToolboxDomainLookups toolboxDomainLookups;
    private DefinitionsCacheRegistry definitionsCacheRegistry;
    private GeneralCreateNodeAction generalCreateNodeAction;

    public AbstractAppendNodeShortcut(ToolboxDomainLookups toolboxDomainLookups, DefinitionsCacheRegistry definitionsCacheRegistry, GeneralCreateNodeAction generalCreateNodeAction) {
        this.toolboxDomainLookups = toolboxDomainLookups;
        this.definitionsCacheRegistry = definitionsCacheRegistry;
        this.generalCreateNodeAction = generalCreateNodeAction;
    }

    public void executeAction(AbstractCanvasHandler canvasHandler, String selectedNodeId) {
        Node sourceNode = CanvasLayoutUtils.getElement(canvasHandler, selectedNodeId).asNode();
        String definitionSetId = canvasHandler.getDiagram().getMetadata().getDefinitionSetId();
        CommonDomainLookups commonDomainLookups = this.toolboxDomainLookups.get(definitionSetId);
        Set connectorDefinitionIds = commonDomainLookups.lookupTargetConnectors(sourceNode);
        block0: for (String connectorDefinitionId : connectorDefinitionIds) {
            Set targetNodesDefinitionIds = commonDomainLookups.lookupTargetNodes(canvasHandler.getDiagram().getGraph(), sourceNode, connectorDefinitionId);
            for (String targetNodeDefinitionId : targetNodesDefinitionIds) {
                Object definition = this.definitionsCacheRegistry.getDefinitionById(targetNodeDefinitionId);
                if (!this.canAppendNodeOfDefinition(definition)) continue;
                this.generalCreateNodeAction.executeAction(canvasHandler, selectedNodeId, targetNodeDefinitionId, connectorDefinitionId);
                continue block0;
            }
        }
    }

    public abstract boolean canAppendNodeOfDefinition(Object var1);
}

