/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.proxies;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.components.proxies.ShapeProxyView;
import org.kie.workbench.common.stunner.core.client.shape.ElementShape;

public abstract class AbstractShapeProxyView<S extends ElementShape>
implements ShapeProxyView<S> {
    private Canvas canvas;
    private Supplier<S> shapeBuilder;
    private Consumer<S> shapeAcceptor;
    private Consumer<S> shapeDestroyer;

    @Override
    public AbstractShapeProxyView<S> onCreate(Supplier<S> shape) {
        this.shapeBuilder = shape;
        return this;
    }

    @Override
    public AbstractShapeProxyView<S> onAccept(Consumer<S> shape) {
        this.shapeAcceptor = shape;
        return this;
    }

    @Override
    public AbstractShapeProxyView<S> onDestroy(Consumer<S> shape) {
        this.shapeDestroyer = shape;
        return this;
    }

    @Override
    public AbstractShapeProxyView<S> setCanvas(Canvas canvas) {
        this.canvas = canvas;
        return this;
    }

    @Override
    public void destroy() {
        this.doDestroy();
        this.canvas = null;
        this.shapeBuilder = null;
        this.shapeAcceptor = null;
        this.shapeDestroyer = null;
    }

    protected abstract void doDestroy();

    protected Canvas getCanvas() {
        return this.canvas;
    }

    protected Supplier<S> getShapeBuilder() {
        return this.shapeBuilder;
    }

    protected Consumer<S> getShapeAcceptor() {
        return this.shapeAcceptor;
    }

    protected Consumer<S> getShapeDestroyer() {
        return this.shapeDestroyer;
    }
}

