/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.appformer.client.stateControl.registry.Registry;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.ClipboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.EdgeClipboard;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CopySelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CopySelectionSessionCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CutSelectionSessionCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.command.impl.ReverseCommand;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.util.Counter;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
@Default
public class PasteSelectionSessionCommand
extends AbstractClientSessionCommand<EditorSession> {
    static final int DEFAULT_PADDING = 15;
    private static Logger LOGGER = Logger.getLogger(PasteSelectionSessionCommand.class.getName());
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final ManagedInstance<CanvasCommandFactory<AbstractCanvasHandler>> canvasCommandFactoryInstance;
    private final Event<CanvasSelectionEvent> selectionEvent;
    private final Map<String, String> clonedElements;
    private final CopySelectionSessionCommand copySelectionSessionCommand;
    private ClipboardControl<Element, AbstractCanvas, ClientSession> clipboardControl;
    private transient DoubleSummaryStatistics yPositionStatistics;
    private final DefinitionUtils definitionUtils;
    private CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private boolean testEdgeFoundInCanvas = false;
    private boolean testEdgeFoundInClipboard = false;

    protected PasteSelectionSessionCommand() {
        this(null, null, null, null, null);
    }

    @Inject
    public PasteSelectionSessionCommand(SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, @Any ManagedInstance<CanvasCommandFactory<AbstractCanvasHandler>> canvasCommandFactoryInstance, Event<CanvasSelectionEvent> selectionEvent, DefinitionUtils definitionUtils, SessionManager sessionManager) {
        super(true);
        this.sessionCommandManager = sessionCommandManager;
        this.canvasCommandFactoryInstance = canvasCommandFactoryInstance;
        this.selectionEvent = selectionEvent;
        this.clonedElements = new HashMap<String, String>();
        this.copySelectionSessionCommand = CopySelectionSessionCommand.getInstance(sessionManager);
        this.definitionUtils = definitionUtils;
    }

    public void setTestEdgeFoundInCanvas(boolean testEdgeFoundInCanvas) {
        this.testEdgeFoundInCanvas = testEdgeFoundInCanvas;
    }

    public void setTestEdgeFoundInClipboard(boolean testEdgeFoundInClipboard) {
        this.testEdgeFoundInClipboard = testEdgeFoundInClipboard;
    }

    @Override
    public void bind(EditorSession session) {
        super.bind(session);
        session.getKeyboardControl().addKeyShortcutCallback((KeyboardControl.KeyShortcutCallback)new KeyboardControl.KogitoKeyPress(new KeyboardEvent.Key[]{KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.V}, "Edit | Paste selection", () -> {
            if (this.isEnabled()) {
                this.execute();
            }
        }));
        session.getKeyboardControl().addKeyShortcutCallback(this::onKeyDownEvent);
        this.clipboardControl = session.getClipboardControl();
        this.canvasCommandFactory = this.loadCanvasFactory(this.canvasCommandFactoryInstance, this.definitionUtils);
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (this.isEnabled()) {
            this.handleCtrlV(keys);
        }
    }

    private void handleCtrlV(KeyboardEvent.Key[] keys) {
        if (KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.V)) {
            this.execute();
        }
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        if (this.clipboardControl.hasElements()) {
            CommandResult<CanvasViolation> finalResult;
            CompositeCommand.Builder<AbstractCanvasHandler, CanvasViolation> nodesCommandBuilder = this.createCommandBuilder();
            Counter processedNodesCountdown = new Counter((int)this.clipboardControl.getElements().stream().filter(element -> element instanceof Node).count());
            nodesCommandBuilder.addCommands(this.clipboardControl.getElements().stream().filter(element -> element instanceof Node).filter(Objects::nonNull).map(node -> (Node)node).map(node -> {
                String newParentUUID = this.getNewParentUUID((Node)node);
                return this.canvasCommandFactory.cloneNode(node, newParentUUID, this.calculateNewLocation((Node<? extends View<?>, Edge>)node, newParentUUID), this.cloneNodeCallback((Node)node, processedNodesCountdown));
            }).collect(Collectors.toList()));
            if (Objects.equals(nodesCommandBuilder.size(), 0)) {
                return;
            }
            if (this.wasNodesDeletedFromGraph()) {
                this.clipboardControl.getRollbackCommands().forEach(command -> nodesCommandBuilder.addFirstCommand((Command)new ReverseCommand(command)));
                this.clipboardControl.getRollbackCommands().forEach(node -> nodesCommandBuilder.addCommand(node));
                finalResult = this.executeCommands(nodesCommandBuilder, processedNodesCountdown);
            } else {
                finalResult = this.executeCommands(nodesCommandBuilder, processedNodesCountdown);
            }
            if (CommandUtils.isError(finalResult)) {
                LOGGER.severe("Error pasting selection." + this.getCanvasViolations(finalResult));
                return;
            }
            this.fireSelectedElementEvent();
            callback.onSuccess();
            this.clear();
            this.copySelectionSessionCommand.execute();
        }
    }

    private CommandResult<CanvasViolation> executeCommands(CompositeCommand.Builder<AbstractCanvasHandler, CanvasViolation> commandBuilder, Counter processedNodesCountdown) {
        CommandResult nodesResult = this.sessionCommandManager.execute((Object)this.getCanvasHandler(), (Command)commandBuilder.build());
        if (CommandUtils.isError((CommandResult)nodesResult)) {
            return nodesResult;
        }
        CommandResult<CanvasViolation> connectorsResult = this.processConnectors(processedNodesCountdown);
        if (!CommandUtils.isError(connectorsResult)) {
            this.updateCommandsRegistry();
        }
        return new CanvasCommandResultBuilder().setType(nodesResult.getType()).addViolations(Objects.nonNull(nodesResult.getViolations()) ? (Collection)StreamSupport.stream(nodesResult.getViolations().spliterator(), false).collect(Collectors.toList()) : Collections.emptyList()).addViolations(Objects.nonNull(connectorsResult.getViolations()) ? (Collection)StreamSupport.stream(connectorsResult.getViolations().spliterator(), false).collect(Collectors.toList()) : Collections.emptyList()).build();
    }

    private void updateCommandsRegistry() {
        Registry<Command<AbstractCanvasHandler, CanvasViolation>> commandRegistry = ((EditorSession)this.getSession()).getCommandRegistry();
        Command connectorsExecutedCommand = (Command)commandRegistry.pop();
        Command nodesExecutedCommand = (Command)commandRegistry.pop();
        commandRegistry.register((Object)new CompositeCommand.Builder().addCommand(nodesExecutedCommand).addCommand(connectorsExecutedCommand).reverse().build());
    }

    private CommandResult<CanvasViolation> processConnectors(Counter processedNodesCountdown) {
        if (processedNodesCountdown.equalsToValue(0)) {
            CompositeCommand.Builder<AbstractCanvasHandler, CanvasViolation> commandBuilder = this.createCommandBuilder();
            commandBuilder.addCommands(this.clipboardControl.getElements().stream().filter(element -> element instanceof Edge).map(edge -> (Edge)edge).filter(edge -> this.isEdgeFoundInCanvas((Edge)edge) || this.isEdgeFoundInClipboard((Edge)edge)).map(edge -> {
                if (this.isEdgeFoundInCanvas((Edge)edge)) {
                    return this.canvasCommandFactory.cloneConnector(edge, this.clonedElements.get(edge.getSourceNode().getUUID()), this.clonedElements.get(edge.getTargetNode().getUUID()), this.getCanvasHandler().getDiagram().getMetadata().getShapeSetId(), this.cloneEdgeCallback((Edge)edge));
                }
                if (this.isEdgeFoundInClipboard((Edge)edge)) {
                    EdgeClipboard edgeData = (EdgeClipboard)this.clipboardControl.getEdgeMap().get(edge.getUUID());
                    ViewConnector connectionContent = (ViewConnector)edge.getContent();
                    connectionContent.setSourceConnection(edgeData.getSourceConnection());
                    connectionContent.setTargetConnection(edgeData.getTargetConnection());
                    return this.canvasCommandFactory.cloneConnector(edge, this.clonedElements.get(edgeData.getSource()), this.clonedElements.get(edgeData.getTarget()), this.getCanvasHandler().getDiagram().getMetadata().getShapeSetId(), this.cloneEdgeCallback((Edge)edge));
                }
                return null;
            }).collect(Collectors.toList()));
            return this.sessionCommandManager.execute((Object)this.getCanvasHandler(), (Command)commandBuilder.build());
        }
        return new CanvasCommandResultBuilder().build();
    }

    public boolean isEdgeFoundInClipboard(Edge edge) {
        return Objects.nonNull(this.clipboardControl.getEdgeMap().get(edge.getUUID())) || this.testEdgeFoundInClipboard;
    }

    public boolean isEdgeFoundInCanvas(Edge edge) {
        return Objects.nonNull(edge.getSourceNode()) && Objects.nonNull(this.clonedElements.get(edge.getSourceNode().getUUID())) && Objects.nonNull(edge.getTargetNode()) && Objects.nonNull(this.clonedElements.get(edge.getTargetNode().getUUID())) && this.testEdgeFoundInCanvas;
    }

    private CompositeCommand.Builder<AbstractCanvasHandler, CanvasViolation> createCommandBuilder() {
        return new CompositeCommand.Builder();
    }

    private Consumer<Edge> cloneEdgeCallback(Edge candidate) {
        return clone -> this.clonedElements.put(candidate.getUUID(), clone.getUUID());
    }

    public boolean wasNodesDeletedFromGraph() {
        return this.clipboardControl.getElements().stream().allMatch(element -> Objects.isNull(this.getElement(element.getUUID())));
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
        this.clear();
        this.clipboardControl = null;
    }

    public void clear() {
        if (null != this.clipboardControl) {
            this.clipboardControl.clear();
        }
        this.clonedElements.clear();
        this.yPositionStatistics = null;
    }

    public String getCanvasViolations(CommandResult<CanvasViolation> result) {
        if (Objects.nonNull(result) && Objects.nonNull(result.getViolations())) {
            return CommandUtils.toList((Iterable)result.getViolations()).stream().map(Objects::toString).collect(Collectors.joining());
        }
        return "";
    }

    protected void onCopySelectionCommandExecuted(@Observes CopySelectionSessionCommandExecutedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (Objects.equals(this.getSession(), event.getClientSession())) {
            this.setEnabled(true);
            this.fire();
        }
    }

    protected void onCutSelectionCommandExecuted(@Observes CutSelectionSessionCommandExecutedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (Objects.equals(this.getSession(), event.getClientSession())) {
            this.setEnabled(true);
            this.fire();
        }
    }

    private Consumer<Node> cloneNodeCallback(Node candidate, Counter processedNodesCountdown) {
        return clone -> {
            this.clonedElements.put(candidate.getUUID(), clone.getUUID());
            processedNodesCountdown.decrement();
        };
    }

    private void fireSelectedElementEvent() {
        this.selectionEvent.fire((Object)new CanvasSelectionEvent((CanvasHandler)this.getCanvasHandler(), this.clonedElements.values()));
    }

    private String getNewParentUUID(Node node) {
        Optional<Element> selectedParent = this.getSelectedParentElement(node.getUUID());
        if (selectedParent.isPresent() && !Objects.equals(selectedParent.get().getUUID(), node.getUUID()) && this.checkIfExistsOnCanvas(selectedParent.get().getUUID())) {
            return selectedParent.get().getUUID();
        }
        String nodeParentUUID = this.clipboardControl.getParent(node.getUUID());
        if (selectedParent.isPresent() && Objects.equals(selectedParent.get().getUUID(), node.getUUID()) && Objects.nonNull(nodeParentUUID) && this.checkIfExistsOnCanvas(nodeParentUUID)) {
            return nodeParentUUID;
        }
        return this.getCanvasRootUUID();
    }

    private boolean checkIfExistsOnCanvas(String nodeParentUUID) {
        return Objects.nonNull(this.getElement(nodeParentUUID));
    }

    private String getCanvasRootUUID() {
        return this.getCanvasHandler().getDiagram().getMetadata().getCanvasRootUUID();
    }

    private Optional<Element> getSelectedParentElement(String nodeUUID) {
        Collection selectedItems;
        if (null != ((EditorSession)this.getSession()).getSelectionControl() && Objects.nonNull(selectedItems = ((EditorSession)this.getSession()).getSelectionControl().getSelectedItems()) && !selectedItems.isEmpty()) {
            Optional<String> selectedParent = selectedItems.stream().filter(Objects::nonNull).filter(item -> Objects.equals(item, nodeUUID)).findFirst();
            return (selectedParent.isPresent() ? selectedParent : selectedItems.stream().filter(Objects::nonNull).findFirst()).map(this::getElement);
        }
        return Optional.empty();
    }

    private Point2D calculateNewLocation(Node<? extends View<?>, Edge> node, String newParentUUID) {
        Point2D position = GraphUtils.getPosition((View)((View)node.getContent()));
        if (this.hasParentChanged(node, newParentUUID)) {
            return new Point2D(15.0, 15.0);
        }
        if (this.existsOnCanvas(node)) {
            double x = position.getX();
            double max = this.getYPositionStatistics().getMax();
            double min = this.getYPositionStatistics().getMin();
            double y = max + (position.getY() - min) + 15.0;
            return new Point2D(x, y);
        }
        return position;
    }

    private DoubleSummaryStatistics getYPositionStatistics() {
        if (Objects.isNull(this.yPositionStatistics)) {
            this.yPositionStatistics = Stream.concat(this.clipboardControl.getElements().stream().filter(element -> element instanceof Node).map(element -> ((View)element.getContent()).getBounds().getLowerRight()), this.clipboardControl.getElements().stream().filter(element -> element instanceof Node).map(element -> ((View)element.getContent()).getBounds().getUpperLeft())).mapToDouble(bound -> bound.getY()).summaryStatistics();
        }
        return this.yPositionStatistics;
    }

    private boolean hasParentChanged(Node<? extends View<?>, Edge> node, String newParentUUID) {
        return !Objects.equals(this.clipboardControl.getParent(node.getUUID()), newParentUUID);
    }

    private boolean existsOnCanvas(Node<? extends View<?>, Edge> node) {
        return Objects.nonNull(this.getCanvasHandler().getGraphIndex().getNode(node.getUUID()));
    }
}

