/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.UndoableLayoutExecutor;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.uberfire.client.mvp.LockRequiredEvent;

@Dependent
@Default
public class PerformAutomaticLayoutCommand
extends AbstractClientSessionCommand<EditorSession> {
    private final LayoutHelper layoutHelper;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final Event<LockRequiredEvent> locker;

    @Inject
    public PerformAutomaticLayoutCommand(LayoutHelper layoutHelper, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Event<LockRequiredEvent> locker) {
        super(true);
        this.sessionCommandManager = sessionCommandManager;
        this.layoutHelper = layoutHelper;
        this.locker = locker;
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        Diagram diagram = this.getDiagram();
        UndoableLayoutExecutor executor = this.makeExecutor();
        this.layoutHelper.applyLayout(diagram, executor, true);
        this.executeLock();
        callback.onSuccess();
    }

    UndoableLayoutExecutor makeExecutor() {
        return new UndoableLayoutExecutor(this.getCanvasHandler(), (CanvasCommandManager<AbstractCanvasHandler>)this.sessionCommandManager);
    }

    Diagram getDiagram() {
        return ((AbstractCanvasHandler)((EditorSession)this.getSession()).getCanvasHandler()).getDiagram();
    }

    void executeLock() {
        this.locker.fire((Object)new LockRequiredEvent());
    }
}

