/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.ConfirmationDialog;
import org.kie.workbench.common.stunner.core.client.canvas.controls.DeleteNodeConfirmation;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.graph.content.HasStringName;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.util.NodeDefinitionHelper;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.mvp.Command;

@Default
public class DeleteNodeConfirmationImpl
implements DeleteNodeConfirmation {
    private SessionManager sessionManager;
    private DefinitionUtils definitionUtils;
    private ClientTranslationService translationService;
    private ConfirmationDialog confirmationDialog;
    private ManagedInstance<GraphsProvider> graphsProviderInstances;
    private GraphsProvider graphsProvider;
    static final String QUOTE = "\"";
    static final String SEPARATOR = ", ";

    protected DeleteNodeConfirmationImpl() {
    }

    @Inject
    public DeleteNodeConfirmationImpl(@Any ManagedInstance<GraphsProvider> graphsProvider, ConfirmationDialog confirmationDialog, ClientTranslationService translationService, DefinitionUtils definitionUtils, SessionManager sessionManager) {
        this.graphsProviderInstances = graphsProvider;
        this.confirmationDialog = confirmationDialog;
        this.translationService = translationService;
        this.definitionUtils = definitionUtils;
        this.sessionManager = sessionManager;
    }

    @PostConstruct
    public void init() {
        Diagram diagram = this.sessionManager.getCurrentSession().getCanvasHandler().getDiagram();
        Annotation qualifier = this.definitionUtils.getQualifier(diagram.getMetadata().getDefinitionSetId());
        this.graphsProvider = InstanceUtils.lookup(this.graphsProviderInstances, GraphsProvider.class, qualifier);
    }

    @PreDestroy
    public void destroy() {
        this.graphsProviderInstances.destroyAll();
    }

    public boolean requiresDeletionConfirmation(Collection<Element> elements) {
        return !Objects.isNull(this.getGraphsProvider()) && this.getGraphsProvider().isGlobalGraphSelected() && !this.getGraphsProvider().getNonGlobalGraphs().isEmpty() && this.isReferredInAnotherGraph(elements);
    }

    public void confirmDeletion(Command onDeletionAccepted, Command onDeletionRejected, Collection<Element> elements) {
        String referredElementsName = this.getReferredElementsName(elements);
        this.confirmationDialog.show(this.translationService.getValue("DeleteNodeConfirmationDialogImpl.Title"), this.translationService.getValue("DeleteNodeConfirmationDialogImpl.ConfirmationDescription", referredElementsName), this.translationService.getValue("DeleteNodeConfirmationDialogImpl.Question"), onDeletionAccepted, onDeletionRejected);
    }

    GraphsProvider getGraphsProvider() {
        return this.graphsProvider;
    }

    String getReferredElementsName(Collection<Element> elements) {
        StringBuilder builder = new StringBuilder();
        for (Element element : elements) {
            if (!this.isReferredInAnotherGraph(element)) continue;
            Optional<String> name = this.getElementName(element);
            name.ifPresent(value -> {
                if (builder.length() > 0) {
                    builder.append(SEPARATOR);
                }
                builder.append(QUOTE);
                builder.append((String)value);
                builder.append(QUOTE);
            });
        }
        return builder.toString();
    }

    Optional<String> getElementName(Element element) {
        Object definition;
        Object content = element.getContent();
        if (content instanceof Definition && (definition = ((Definition)content).getDefinition()) instanceof HasStringName) {
            String name = ((HasStringName)definition).getStringName();
            if (StringUtils.isEmpty((String)name)) {
                return Optional.empty();
            }
            return Optional.of(name);
        }
        return Optional.empty();
    }

    boolean isReferredInAnotherGraph(Collection<Element> elements) {
        return elements.stream().anyMatch(this::isReferredInAnotherGraph);
    }

    boolean isReferredInAnotherGraph(Element element) {
        Definition def;
        if (element.getContent() instanceof Definition && (def = (Definition)element.getContent()).getDefinition() instanceof HasContentDefinitionId) {
            HasContentDefinitionId hasContentDefinitionId = (HasContentDefinitionId)def.getDefinition();
            String contentId = hasContentDefinitionId.getContentDefinitionId();
            List graphs = this.getGraphsProvider().getNonGlobalGraphs();
            return graphs.stream().anyMatch(graph -> this.containsNodeWithContentId((Graph)graph, contentId));
        }
        return false;
    }

    boolean containsNodeWithContentId(Graph graph, String contentId) {
        return StreamSupport.stream(graph.nodes().spliterator(), false).anyMatch(n -> Objects.equals(NodeDefinitionHelper.getContentDefinitionId((Node)((Node)n)), contentId));
    }
}

