/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.Objects;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;

public class CanvasUndockNodeCommand
extends AbstractCanvasCommand {
    private final Node parent;
    private final Node child;

    public CanvasUndockNodeCommand(Node parent, Node child) {
        this.parent = parent;
        this.child = child;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        if (Objects.isNull(this.parent) || Objects.isNull(this.child)) {
            throw new IllegalArgumentException("Parent and child should not be null");
        }
        context.undock((Element)this.parent, (Element)this.child);
        this.getChild().getInEdges().stream().filter(e -> e.getContent() instanceof Child).findAny().ifPresent(e -> context.addChild((Element)e.getSourceNode(), (Element)this.child));
        if (this.existNode(this.parent, context)) {
            context.applyElementMutation((Element)this.parent, MutationContext.STATIC);
        }
        if (this.existNode(this.child, context)) {
            context.applyElementMutation((Element)this.child, MutationContext.STATIC);
        }
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new CanvasDockNodeCommand(this.parent, this.child).execute(context);
    }

    public Node getParent() {
        return this.parent;
    }

    public Node<?, Edge> getChild() {
        return this.child;
    }

    private boolean existNode(Node node, AbstractCanvasHandler context) {
        return null != context.getGraphIndex().getNode(node.getUUID());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [parent=" + CanvasUndockNodeCommand.toUUID(this.parent) + ",candidate=" + CanvasUndockNodeCommand.toUUID(this.child) + "]";
    }
}

