/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasControlPointCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.util.ControlPointValidations;

public class DeleteCanvasControlPointCommand
extends AbstractCanvasCommand {
    private final Edge candidate;
    private final int index;
    private ControlPoint deletedControlPoint;

    public DeleteCanvasControlPointCommand(Edge candidate, int index) {
        this.candidate = candidate;
        this.index = index;
    }

    @Override
    public CommandResult<CanvasViolation> allow(AbstractCanvasHandler context) {
        ControlPointValidations.checkDeleteControlPoint((ControlPoint[])AddCanvasControlPointCommand.getViewControlPoints(context, this.candidate), (int)this.index);
        return CanvasCommandResultBuilder.SUCCESS;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        this.allow(context);
        AddCanvasControlPointCommand.consumeControlPoints(context, this.candidate, view -> {
            this.deletedControlPoint = view.getManageableControlPoints()[this.index];
            view.deleteControlPoint(this.index);
        });
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new AddCanvasControlPointCommand(this.candidate, this.deletedControlPoint, this.index).execute(context);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [candidate=" + DeleteCanvasControlPointCommand.toUUID(this.candidate) + ",index=" + this.index + "]";
    }
}

