/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.Collection;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeleteElementsCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class DeleteElementsCommand
extends AbstractCanvasGraphCommand {
    protected final Collection<Element> elements;
    private transient CompositeCommand<AbstractCanvasHandler, CanvasViolation> command;

    public DeleteElementsCommand(Collection<Element> elements) {
        this.elements = elements;
        this.command = new CompositeCommand.Builder().reverse().build();
    }

    public Collection<Element> getElements() {
        return this.elements;
    }

    @Override
    protected Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new org.kie.workbench.common.stunner.core.graph.command.impl.DeleteElementsCommand(() -> this.elements, (DeleteElementsCommand.DeleteCallback)new CanvasMultipleDeleteProcessor());
    }

    @Override
    protected Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return this.command;
    }

    protected CompositeCommand<AbstractCanvasHandler, CanvasViolation> getCommand() {
        return this.command;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [elements=" + this.elements + "]";
    }

    public class CanvasMultipleDeleteProcessor
    implements DeleteElementsCommand.DeleteCallback {
        public SafeDeleteNodeCommand.SafeDeleteNodeCommandCallback onDeleteNode(Node<?, Edge> node, SafeDeleteNodeCommand.Options options) {
            DeleteNodeCommand.CanvasDeleteProcessor processor = this.createProcessor(options);
            DeleteElementsCommand.this.getCommand().addCommand(processor.getCommand());
            return processor;
        }

        public void onDeleteEdge(Edge<? extends View, Node> edge) {
            DeleteElementsCommand.this.getCommand().addCommand((Command)new DeleteCanvasConnectorCommand(edge));
        }

        protected DeleteNodeCommand.CanvasDeleteProcessor createProcessor(final SafeDeleteNodeCommand.Options options) {
            return new DeleteNodeCommand.CanvasDeleteProcessor(options){

                @Override
                public boolean deleteConnector(Edge<? extends View<?>, Node> connector) {
                    if (super.deleteConnector(connector)) {
                        options.getExclusions().add(connector.getUUID());
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

