/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.Collection;
import java.util.Collections;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetCanvasChildrenCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;

public class RemoveCanvasChildrenCommand
extends AbstractCanvasCommand {
    private final Node parent;
    private final Collection<Node<?, Edge>> children;

    public RemoveCanvasChildrenCommand(Node parent, Collection<Node<?, Edge>> children) {
        this.parent = parent;
        this.children = children;
    }

    public RemoveCanvasChildrenCommand(Node parent, Node<?, Edge> child) {
        this(parent, Collections.singleton(child));
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        this.children.forEach(child -> {
            context.removeChild((Element)this.parent, (Element)child);
            ShapeUtils.moveViewConnectorsToTop(context, child);
        });
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new SetCanvasChildrenCommand(this.parent, this.children).execute(context);
    }

    public Node getParent() {
        return this.parent;
    }

    public Collection<Node<?, Edge>> getChildren() {
        return this.children;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [parent=" + RemoveCanvasChildrenCommand.toUUID(this.parent) + ",children=" + RemoveCanvasChildrenCommand.toUUIDs(this.children) + "]";
    }
}

