/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.client.api.ClientDefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.ElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.ElementBuildRequest;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationMessages;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleEvaluationContextBuilder;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.kie.workbench.common.stunner.core.validation.Violation;

public abstract class AbstractElementBuilderControl
extends AbstractCanvasHandlerControl<AbstractCanvasHandler>
implements ElementBuilderControl<AbstractCanvasHandler> {
    private final ClientDefinitionManager clientDefinitionManager;
    private final ClientFactoryService clientFactoryServices;
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private final ClientTranslationMessages translationMessages;
    private final RuleManager ruleManager;
    private final GraphBoundsIndexer graphBoundsIndexer;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    public AbstractElementBuilderControl(ClientDefinitionManager clientDefinitionManager, ClientFactoryService clientFactoryServices, RuleManager ruleManager, CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, ClientTranslationMessages translationMessages, GraphBoundsIndexer graphBoundsIndexer) {
        this.clientDefinitionManager = clientDefinitionManager;
        this.clientFactoryServices = clientFactoryServices;
        this.ruleManager = ruleManager;
        this.canvasCommandFactory = canvasCommandFactory;
        this.translationMessages = translationMessages;
        this.graphBoundsIndexer = graphBoundsIndexer;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    protected ParentAssignment getParentAssignment(Node<View<?>, Edge> parent, Object definition) {
        Objects.requireNonNull(definition);
        Set labels = Arrays.stream(this.clientDefinitionManager.adapters().forDefinition().getLabels(definition)).collect(Collectors.toSet());
        RuleSet ruleSet = this.canvasHandler.getRuleSet();
        if (null != parent) {
            Set parentLabels = parent.getLabels();
            RuleViolations dockingViolations = this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)RuleEvaluationContextBuilder.DomainContexts.docking((Set)parentLabels, labels));
            if (this.isValid(dockingViolations)) {
                return ParentAssignment.DOCKING;
            }
            RuleViolations containmentViolations = this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)RuleEvaluationContextBuilder.DomainContexts.containment((Set)parentLabels, labels));
            if (this.isValid(containmentViolations)) {
                return ParentAssignment.CONTAINMENT;
            }
        }
        return ParentAssignment.NONE;
    }

    public boolean allows(ElementBuildRequest<AbstractCanvasHandler> request) {
        double x = request.getX();
        double y = request.getY();
        Object definition = request.getDefinition();
        Node<View<?>, Edge> parent = this.getParent(x, y);
        Set labels = Arrays.stream(this.clientDefinitionManager.adapters().forDefinition().getLabels(definition)).collect(Collectors.toSet());
        RuleSet ruleSet = this.canvasHandler.getRuleSet();
        if (Objects.nonNull(parent) && ParentAssignment.NONE.equals((Object)this.getParentAssignment(parent, definition))) {
            return false;
        }
        Map graphLabelCount = GraphUtils.getLabelsCount((Graph)this.canvasHandler.getDiagram().getGraph(), labels);
        DefaultRuleViolations cardinalityViolations = new DefaultRuleViolations();
        for (String role : labels) {
            Integer roleCount = Optional.ofNullable((Integer)graphLabelCount.get(role)).orElse(0);
            RuleViolations violations = this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)RuleEvaluationContextBuilder.DomainContexts.cardinality(Collections.singleton(role), (int)roleCount, Optional.of(CardinalityContext.Operation.ADD)));
            cardinalityViolations.addViolations(violations);
        }
        return this.isValid((RuleViolations)cardinalityViolations);
    }

    public void build(ElementBuildRequest<AbstractCanvasHandler> request, final BuilderControl.BuildCallback buildCallback) {
        if (null == this.canvasHandler) {
            buildCallback.onSuccess(null);
            return;
        }
        double x = request.getX();
        double y = request.getY();
        Object definition = request.getDefinition();
        this.fireProcessingStarted();
        Node<View<?>, Edge> parent = this.getParent(x, y);
        Point2D childCoordinates = this.getComputedChildCoordinates(parent, x, y);
        this.getCommands(definition, parent, childCoordinates.getX(), childCoordinates.getY(), new CommandsCallback(){

            @Override
            public void onComplete(String uuid, List<Command<AbstractCanvasHandler, CanvasViolation>> commands) {
                CommandResult result = AbstractElementBuilderControl.this.getCommandManager().execute((Object)AbstractElementBuilderControl.this.canvasHandler, (Command)new CompositeCommand.Builder().addCommands(commands).build());
                if (!CommandUtils.isError((CommandResult)result)) {
                    buildCallback.onSuccess(uuid);
                } else {
                    String message = AbstractElementBuilderControl.this.translationMessages.getCanvasCommandValidationsErrorMessage(result.getViolations());
                    buildCallback.onError(new ClientRuntimeError(message));
                }
                AbstractElementBuilderControl.this.fireProcessingCompleted();
            }

            @Override
            public void onError(ClientRuntimeError error) {
                buildCallback.onError(error);
                AbstractElementBuilderControl.this.fireProcessingCompleted();
            }
        });
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doDestroy() {
        this.graphBoundsIndexer.destroy();
        this.commandManagerProvider = null;
    }

    public void getCommands(final Object definition, final Node<View<?>, Edge> parent, final double x, final double y, final CommandsCallback commandsCallback) {
        String defId = this.clientDefinitionManager.adapters().forDefinition().getId(definition).value();
        String uuid = UUID.uuid();
        this.clientFactoryServices.newElement(uuid, defId, new ServiceCallback<Element>(){

            public void onSuccess(Element element) {
                AbstractElementBuilderControl.this.updateElementFromDefinition(element, definition);
                AbstractElementBuilderControl.this.getElementCommands(element, parent, AbstractElementBuilderControl.this.getParentAssignment(parent, definition), x, y, new CommandsCallback(){

                    @Override
                    public void onComplete(String uuid, List<Command<AbstractCanvasHandler, CanvasViolation>> commands) {
                        commandsCallback.onComplete(uuid, commands);
                    }

                    @Override
                    public void onError(ClientRuntimeError error) {
                        commandsCallback.onError(error);
                    }
                });
            }

            public void onError(ClientRuntimeError error) {
                commandsCallback.onError(error);
            }
        });
    }

    protected void updateElementFromDefinition(Element element, Object definition) {
    }

    public void getElementCommands(Element element, Node<View<?>, Edge> parent, ParentAssignment parentAssignment, double x, double y, CommandsCallback commandsCallback) {
        LinkedList<Command<AbstractCanvasHandler, CanvasViolation>> commandList = new LinkedList<Command<AbstractCanvasHandler, CanvasViolation>>();
        if (element instanceof Node) {
            Node node = (Node)element;
            commandList.addAll(this.getNodeBuildCommands(node, parent, parentAssignment, x, y));
        } else if (element instanceof Edge && null != parent) {
            commandList.add((Command<AbstractCanvasHandler, CanvasViolation>)this.canvasCommandFactory.addConnector(parent, (Edge)element, (Connection)MagnetConnection.Builder.atCenter(parent), this.getShapeSetId()));
        } else {
            throw new IllegalStateException("Unrecognized element type for " + element);
        }
        commandsCallback.onComplete(element.getUUID(), commandList);
    }

    private CanvasCommand<AbstractCanvasHandler> getUpdatePositionCommand(double x, double y, Node<View<?>, Edge> node) {
        return this.canvasCommandFactory.updatePosition(node, new Point2D(x, y));
    }

    private List<CanvasCommand<AbstractCanvasHandler>> getNodeBuildCommands(Node<View<?>, Edge> node, Node<View<?>, Edge> parent, ParentAssignment parentAssignment, double x, double y) {
        LinkedList<CanvasCommand<AbstractCanvasHandler>> commandList = new LinkedList<CanvasCommand<AbstractCanvasHandler>>();
        if (Objects.isNull(parent)) {
            return this.getNoParentCommands(node, x, y);
        }
        switch (parentAssignment) {
            case DOCKING: {
                Node grandParent = (Node)GraphUtils.getParent(parent);
                commandList.add(this.canvasCommandFactory.addChildNode(grandParent, node, this.getShapeSetId()));
                commandList.add((CanvasCommand<AbstractCanvasHandler>)this.canvasCommandFactory.updatePosition(node, new Point2D(x, y)));
                commandList.add((CanvasCommand<AbstractCanvasHandler>)this.canvasCommandFactory.updateDockNode(parent, node, true));
                return commandList;
            }
            case CONTAINMENT: {
                commandList.add(this.canvasCommandFactory.addChildNode(parent, node, this.getShapeSetId()));
                commandList.add(this.getUpdatePositionCommand(x, y, node));
                return commandList;
            }
        }
        return this.getNoParentCommands(node, x, y);
    }

    private List<CanvasCommand<AbstractCanvasHandler>> getNoParentCommands(Node<View<?>, Edge> node, double x, double y) {
        return Arrays.asList(this.canvasCommandFactory.addNode(node, this.getShapeSetId()), this.getUpdatePositionCommand(x, y, node));
    }

    public Node<View<?>, Edge> getParent(double _x, double _y) {
        if (_x > -1.0 && _y > -1.0) {
            String rootUUID = this.canvasHandler.getDiagram().getMetadata().getCanvasRootUUID();
            this.graphBoundsIndexer.setRootUUID(rootUUID).build((Object)this.canvasHandler.getDiagram().getGraph());
            Node r = (Node)this.graphBoundsIndexer.getAt(_x, _y);
            return r;
        }
        return null;
    }

    public Point2D getComputedChildCoordinates(Node<View<?>, Edge> parent, double _x, double _y) {
        if (null != parent) {
            Point2D parentCoords = GraphUtils.getComputedPosition(parent);
            double x = _x - parentCoords.getX();
            double y = _y - parentCoords.getY();
            return new Point2D(x, y);
        }
        return new Point2D(_x, _y);
    }

    protected void fireProcessingStarted() {
    }

    protected void fireProcessingCompleted() {
    }

    protected boolean isValid(RuleViolations violations) {
        return !violations.violations(Violation.Type.ERROR).iterator().hasNext();
    }

    protected String getShapeSetId() {
        return this.canvasHandler.getDiagram().getMetadata().getShapeSetId();
    }

    CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }

    public static interface CommandsCallback {
        public void onComplete(String var1, List<Command<AbstractCanvasHandler, CanvasViolation>> var2);

        public void onError(ClientRuntimeError var1);
    }

    static enum ParentAssignment {
        DOCKING,
        CONTAINMENT,
        NONE;

    }
}

