/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.appformer.client.stateControl.registry.Registry;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequestCommands;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;

@Dependent
@Typed(value={RegistryAwareCommandManager.class})
public class RegistryAwareCommandManager
implements SessionCommandManager<AbstractCanvasHandler> {
    private final RequestCommands commands;
    private final SessionManager sessionManager;

    @Inject
    public RegistryAwareCommandManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.commands = new RequestCommands.Builder().onComplete(command -> this.getCommandRegistry().ifPresent(r -> r.register(command))).onRollback(command -> this.undo(this.getCanvasHandler(), (Command<AbstractCanvasHandler, CanvasViolation>)command)).build();
    }

    public CommandResult<CanvasViolation> allow(Command<AbstractCanvasHandler, CanvasViolation> command) {
        return this.allow(this.getCanvasHandler(), command);
    }

    public CommandResult<CanvasViolation> execute(Command<AbstractCanvasHandler, CanvasViolation> command) {
        return this.execute(this.getCanvasHandler(), command);
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        Command lastEntry = this.getCommandRegistry().map(Registry::pop).orElse(null);
        if (null != lastEntry) {
            return this.undo(context, (Command<AbstractCanvasHandler, CanvasViolation>)lastEntry);
        }
        return CanvasCommandResultBuilder.failed();
    }

    public CommandResult<CanvasViolation> undo() {
        return this.undo(this.getCanvasHandler());
    }

    public CommandResult<CanvasViolation> allow(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command) {
        return this.getCommandManager().allow((Object)context, command);
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command) {
        CommandResult result = this.getCommandManager().execute((Object)context, command);
        if (CommandUtils.isError((CommandResult)result)) {
            this.rollback();
        } else if (this.commands.isStarted()) {
            this.commands.push(command);
        } else {
            this.getCommandRegistry().ifPresent(r -> r.register((Object)command));
        }
        return result;
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command) {
        return this.getCommandManager().undo((Object)context, command);
    }

    public void start() {
        if (!this.commands.isStarted()) {
            this.commands.start();
        }
    }

    public void rollback() {
        this.commands.rollback();
    }

    public void complete() {
        this.commands.complete();
    }

    @PreDestroy
    public void destroy() {
        this.commands.clear();
    }

    private Optional<EditorSession> ifEditorSession() {
        if (this.sessionManager.getCurrentSession() instanceof EditorSession) {
            return Optional.of((EditorSession)this.sessionManager.getCurrentSession());
        }
        return Optional.empty();
    }

    private Optional<Registry<Command<AbstractCanvasHandler, CanvasViolation>>> getCommandRegistry() {
        return this.ifEditorSession().map(EditorSession::getCommandRegistry);
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        ClientSession session = this.sessionManager.getCurrentSession();
        if (session instanceof EditorSession) {
            return ((EditorSession)session).getCommandManager();
        }
        return ((ViewerSession)session).getCommandManager();
    }

    private AbstractCanvasHandler getCanvasHandler() {
        return (AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler();
    }
}

