/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.components.palette.AbstractPaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteCategory;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteDefinitionBuilders;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteDefinitionProviders;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteGroup;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteItem;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;
import org.kie.workbench.common.stunner.core.profile.DomainProfileManager;
import org.kie.workbench.common.stunner.core.registry.impl.DefinitionsCacheRegistry;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
@Default
public class ExpandedPaletteDefinitionBuilder
extends AbstractPaletteDefinitionBuilder<ExpandedPaletteDefinitionBuilder> {
    private Function<Object, MorphDefinition> morphDefinitionProvider;
    private Predicate<String> groupFilter;
    private Function<String, String> categoryDefinitionIdProvider;
    private Function<String, Glyph> categoryGlyphProvider;
    private AbstractPaletteDefinitionBuilder.ItemMessageProvider groupMessageProvider;
    private AbstractPaletteDefinitionBuilder.ItemMessageProvider categoryMessageProvider;
    private Function<String, String> customGroupIdProvider;
    private AbstractPaletteDefinitionBuilder.ItemMessageProvider customGroupMessageProvider;

    public ExpandedPaletteDefinitionBuilder categoryDefinitionIdProvider(Function<String, String> categoryDefinitionIdProvider) {
        this.categoryDefinitionIdProvider = categoryDefinitionIdProvider;
        return this;
    }

    public ExpandedPaletteDefinitionBuilder morphDefinitionProvider(Function<Object, MorphDefinition> morphDefinitionProvider) {
        this.morphDefinitionProvider = morphDefinitionProvider;
        return this;
    }

    public ExpandedPaletteDefinitionBuilder groupFilter(Predicate<String> groupFilter) {
        this.groupFilter = groupFilter;
        return this;
    }

    public ExpandedPaletteDefinitionBuilder categoryGlyphProvider(Function<String, Glyph> categoryGlyphProvider) {
        this.categoryGlyphProvider = categoryGlyphProvider;
        return this;
    }

    public ExpandedPaletteDefinitionBuilder groupMessages(AbstractPaletteDefinitionBuilder.ItemMessageProvider provider) {
        this.groupMessageProvider = provider;
        return this;
    }

    public ExpandedPaletteDefinitionBuilder categoryMessages(AbstractPaletteDefinitionBuilder.ItemMessageProvider provider) {
        this.categoryMessageProvider = provider;
        return this;
    }

    public ExpandedPaletteDefinitionBuilder customGroupIdProvider(Function<String, String> customGroupIdProvider) {
        this.customGroupIdProvider = customGroupIdProvider;
        return this;
    }

    public ExpandedPaletteDefinitionBuilder customGroupMessages(AbstractPaletteDefinitionBuilder.ItemMessageProvider provider) {
        this.customGroupMessageProvider = provider;
        return this;
    }

    @Inject
    public ExpandedPaletteDefinitionBuilder(DefinitionUtils definitionUtils, DomainProfileManager profileManager, DefinitionsCacheRegistry definitionsRegistry, StunnerTranslationService translationService) {
        super(definitionUtils, profileManager, definitionsRegistry, translationService);
        this.initDefaults();
    }

    @Override
    protected DefaultPaletteItem createItem(Object definition, String categoryId, Metadata metadata, Function<String, DefaultPaletteItem> itemSupplier) {
        String groupTitle;
        Optional<DefaultPaletteItem> groupOp;
        MorphDefinition morphDefinition;
        DefinitionAdapter definitionAdapter = this.getDefinitionManager().adapters().forDefinition();
        String id = definitionAdapter.getId(definition).value();
        DefaultPaletteCategory result = null;
        DefaultPaletteCategory category = (DefaultPaletteCategory)itemSupplier.apply(categoryId);
        if (null == category) {
            String catDefId = this.categoryDefinitionIdProvider.apply(categoryId);
            String catTitle = this.categoryMessageProvider.getTitle(categoryId);
            String catDesc = this.categoryMessageProvider.getDescription(categoryId);
            Glyph categoryGlyph = this.categoryGlyphProvider.apply(categoryId);
            result = category = ((DefaultPaletteDefinitionBuilders.CategoryBuilder)((DefaultPaletteDefinitionBuilders.CategoryBuilder)((DefaultPaletteDefinitionBuilders.CategoryBuilder)((DefaultPaletteDefinitionBuilders.CategoryBuilder)((DefaultPaletteDefinitionBuilders.CategoryBuilder)new DefaultPaletteDefinitionBuilders.CategoryBuilder().setItemId(categoryId)).setDefinitionId(catDefId)).setTitle(catTitle)).setDescription(catDesc)).setTooltip(catTitle)).setGlyph(categoryGlyph).build();
        }
        boolean hasMorphBase = null != (morphDefinition = this.morphDefinitionProvider.apply(definition));
        String morphDefault = null;
        DefaultPaletteGroup group = null;
        if (hasMorphBase) {
            String morphBaseId = morphDefinition.getBase();
            if (this.groupFilter.test(morphBaseId)) {
                morphDefault = morphDefinition.getDefault();
                groupOp = category.getItems().stream().filter(g -> g.getId().equals(morphBaseId)).findFirst();
                if (!groupOp.isPresent()) {
                    groupTitle = this.groupMessageProvider.getTitle(morphBaseId);
                    String groupDesc = this.groupMessageProvider.getDescription(morphBaseId);
                    group = ((DefaultPaletteDefinitionBuilders.GroupBuilder)((DefaultPaletteDefinitionBuilders.GroupBuilder)((DefaultPaletteDefinitionBuilders.GroupBuilder)((DefaultPaletteDefinitionBuilders.GroupBuilder)new DefaultPaletteDefinitionBuilders.GroupBuilder().setItemId(morphBaseId)).setDefinitionId(morphDefault)).setTitle(groupTitle)).setDescription(groupDesc)).build();
                    category.getItems().add(group);
                } else {
                    group = (DefaultPaletteGroup)groupOp.get();
                }
            }
        } else {
            String customGroupId;
            String string = customGroupId = this.customGroupIdProvider != null ? this.customGroupIdProvider.apply(id) : null;
            if (customGroupId != null && this.groupFilter.test(customGroupId)) {
                groupOp = category.getItems().stream().filter(g -> g.getId().equals(customGroupId)).findFirst();
                if (!groupOp.isPresent()) {
                    groupTitle = this.customGroupMessageProvider.getTitle(customGroupId);
                    String groupDesc = this.groupMessageProvider.getDescription(customGroupId);
                    group = ((DefaultPaletteDefinitionBuilders.GroupBuilder)((DefaultPaletteDefinitionBuilders.GroupBuilder)((DefaultPaletteDefinitionBuilders.GroupBuilder)new DefaultPaletteDefinitionBuilders.GroupBuilder().setItemId(customGroupId)).setTitle(groupTitle)).setDescription(groupDesc)).build();
                    category.getItems().add(group);
                } else {
                    group = (DefaultPaletteGroup)groupOp.get();
                }
            }
        }
        String title = definitionAdapter.getTitle(definition);
        String description = definitionAdapter.getDescription(definition);
        DefaultPaletteItem item = ((DefaultPaletteDefinitionBuilders.ItemBuilder)((DefaultPaletteDefinitionBuilders.ItemBuilder)((DefaultPaletteDefinitionBuilders.ItemBuilder)((DefaultPaletteDefinitionBuilders.ItemBuilder)new DefaultPaletteDefinitionBuilders.ItemBuilder().setItemId(id)).setDefinitionId(id)).setTitle(title)).setDescription(description)).build();
        if (null != group) {
            if (null != morphDefault && morphDefault.equals(id)) {
                group.getItems().add(0, item);
            } else {
                group.getItems().add(item);
            }
        } else {
            category.getItems().add(item);
        }
        return result;
    }

    private void initDefaults() {
        this.morphDefinitionProvider(arg_0 -> ((DefinitionUtils)this.definitionUtils).getMorphDefinition(arg_0)).groupFilter(id -> true).categoryDefinitionIdProvider(id -> null).categoryGlyphProvider(DefaultPaletteDefinitionProviders.DEFAULT_CATEGORY_GLYPH_PROVIDER).groupMessages(new DefaultPaletteDefinitionProviders.DefaultMorphGroupMessageProvider(this.translationService)).categoryMessages(new DefaultPaletteDefinitionProviders.DefaultMessageProvider());
    }

    public Function<Object, MorphDefinition> getMorphDefinitionProvider() {
        return this.morphDefinitionProvider;
    }

    public Predicate<String> getGroupFilter() {
        return this.groupFilter;
    }

    public AbstractPaletteDefinitionBuilder.ItemMessageProvider getCategoryMessageProvider() {
        return this.categoryMessageProvider;
    }

    public AbstractPaletteDefinitionBuilder.ItemMessageProvider getGroupMessageProvider() {
        return this.groupMessageProvider;
    }

    public Function<String, Glyph> getCategoryGlyphProvider() {
        return this.categoryGlyphProvider;
    }

    public Function<String, String> getCategoryDefinitionIdProvider() {
        return this.categoryDefinitionIdProvider;
    }
}

