/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.definition.adapter.binding;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.jboss.errai.databinding.client.BindableProxy;
import org.jboss.errai.databinding.client.HasProperties;
import org.jboss.errai.databinding.client.PropertyType;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class ClientBindingUtils {
    public static <T> Class<?> getProxiedType(T pojo, String fieldName) {
        HasProperties hasProperties;
        PropertyType propertyType;
        if (null != pojo && null != fieldName && null != (propertyType = (PropertyType)(hasProperties = (HasProperties)DataBinder.forModel(pojo).getModel()).getBeanProperties().get(fieldName))) {
            return propertyType.getType();
        }
        return null;
    }

    public static <T, R> R getProxiedValue(T pojo, String fieldName) {
        Object result = null;
        if (null != pojo && StringUtils.nonEmpty((String)fieldName)) {
            PropertyHolder propertyHolder = ClientBindingUtils.getProperty(pojo, fieldName);
            result = propertyHolder.getValue().orElse(null);
        }
        return result;
    }

    public static <T, R> Set<R> getProxiedSet(T pojo, Collection<String> fieldNames) {
        LinkedHashSet result = new LinkedHashSet();
        if (null != pojo && null != fieldNames && !fieldNames.isEmpty()) {
            for (String fieldName : fieldNames) {
                PropertyHolder propertyHolder = ClientBindingUtils.getProperty(pojo, fieldName);
                propertyHolder.getValue().ifPresent(value -> result.add(value));
            }
        }
        return result;
    }

    public static <T, V> void setProxiedValue(T pojo, String fieldName, V value) {
        if (null != pojo && StringUtils.nonEmpty((String)fieldName)) {
            PropertyHolder propertyHolder = ClientBindingUtils.getProperty(pojo, fieldName);
            propertyHolder.setValue(value);
        }
    }

    private static PropertyHolder getProperty(Object pojo, String fieldName) {
        int index = fieldName.indexOf(46);
        if (index > -1) {
            String parentField = fieldName.substring(0, index);
            String field = fieldName.substring(index + 1);
            HasProperties hasProperties = (HasProperties)DataBinder.forModel((Object)pojo).getModel();
            Object parent = hasProperties.get(parentField);
            if (null == parent) {
                return PropertyHolder.empty();
            }
            HasProperties parentHasProperties = (HasProperties)DataBinder.forModel((Object)parent).getModel();
            return new PropertyHolder(parentHasProperties, field);
        }
        HasProperties hasProperties = (HasProperties)DataBinder.forModel((Object)pojo).getModel();
        return new PropertyHolder(hasProperties, fieldName);
    }

    public static <T> T clone(T pojo) {
        if (null != pojo) {
            BindableProxy proxy = (BindableProxy)DataBinder.forModel(pojo).getModel();
            return (T)proxy.deepUnwrap();
        }
        return null;
    }

    private static class PropertyHolder {
        private HasProperties hasProperties;
        private String fieldName;

        public static PropertyHolder empty() {
            return new PropertyHolder(null, null);
        }

        public PropertyHolder(HasProperties hasProperties, String fieldName) {
            this.hasProperties = hasProperties;
            this.fieldName = fieldName;
        }

        public Optional<?> getValue() {
            return null != this.hasProperties ? Optional.ofNullable(this.hasProperties.get(this.fieldName)) : Optional.empty();
        }

        public void setValue(Object value) {
            if (null != this.hasProperties) {
                this.hasProperties.set(this.fieldName, value);
            }
        }
    }
}

