/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.view.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.core.client.shape.TextWrapperStrategy;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeViewHandler;

public class FontHandler<W, V extends ShapeView>
implements ShapeViewHandler<W, V> {
    private final Function<W, Double> alphaProvider;
    private final Function<W, String> fontFamilyProvider;
    private final Function<W, String> fontColorProvider;
    private final Function<W, Double> fontSizeProvider;
    private final Function<W, String> strokeColorProvider;
    private final Function<W, Double> strokeSizeProvider;
    private final Function<W, Double> strokeAlphaProvider;
    private final Function<W, Double> positionXOffsetProvider;
    private final Function<W, Double> positionYOffsetProvider;
    private final Function<W, Double> rotationProvider;
    private final Function<W, TextWrapperStrategy> textWrapperStrategyProvider;
    private Function<W, HasTitle.VerticalAlignment> verticalAlignmentProvider;
    private Function<W, HasTitle.HorizontalAlignment> horizontalAlignmentProvider;
    private Function<W, HasTitle.ReferencePosition> referencePositionProvider;
    private Function<W, HasTitle.Orientation> orientationProvider;
    private final Function<W, HasTitle.Size> sizeConstraintsProvider;
    private final Map<Enum, Double> margins;
    private final Function<W, Map<Enum, Double>> marginsProvider;

    FontHandler(Function<W, Double> alphaProvider, Function<W, String> fontFamilyProvider, Function<W, String> fontColorProvider, Function<W, Double> fontSizeProvider, Function<W, String> strokeColorProvider, Function<W, Double> strokeSizeProvider, Function<W, Double> strokeAlphaProvider, Function<W, Double> positionXOffsetProvider, Function<W, Double> positionYOffsetProvider, Function<W, Double> rotationProvider, Function<W, TextWrapperStrategy> textWrapperStrategyProvider, Function<W, HasTitle.VerticalAlignment> verticalAlignmentProvider, Function<W, HasTitle.HorizontalAlignment> horizontalAlignmentProvider, Function<W, HasTitle.ReferencePosition> referencePositionProvider, Function<W, HasTitle.Orientation> orientationProvider, Function<W, HasTitle.Size> sizeConstraintsProvider, Map<Enum, Double> margins, Function<W, Map<Enum, Double>> marginsProvider) {
        this.alphaProvider = alphaProvider;
        this.fontFamilyProvider = fontFamilyProvider;
        this.fontColorProvider = fontColorProvider;
        this.fontSizeProvider = fontSizeProvider;
        this.strokeColorProvider = strokeColorProvider;
        this.strokeSizeProvider = strokeSizeProvider;
        this.strokeAlphaProvider = strokeAlphaProvider;
        this.positionXOffsetProvider = positionXOffsetProvider;
        this.positionYOffsetProvider = positionYOffsetProvider;
        this.rotationProvider = rotationProvider;
        this.textWrapperStrategyProvider = textWrapperStrategyProvider;
        this.verticalAlignmentProvider = verticalAlignmentProvider;
        this.horizontalAlignmentProvider = horizontalAlignmentProvider;
        this.referencePositionProvider = referencePositionProvider;
        this.orientationProvider = orientationProvider;
        this.sizeConstraintsProvider = sizeConstraintsProvider;
        this.margins = margins;
        this.marginsProvider = marginsProvider;
    }

    public void handle(W element, V view) {
        if (view instanceof HasTitle) {
            HasTitle hasTitle = (HasTitle)view;
            Double alpha = this.alphaProvider.apply(element);
            String fontFamily = this.fontFamilyProvider.apply(element);
            String fontColor = this.fontColorProvider.apply(element);
            Double fontSize = this.fontSizeProvider.apply(element);
            String strokeColor = this.strokeColorProvider.apply(element);
            Double strokeSize = this.strokeSizeProvider.apply(element);
            Double strokeAlpha = this.strokeAlphaProvider.apply(element);
            Double positionXOffset = this.positionXOffsetProvider.apply(element);
            Double positionYOffset = this.positionYOffsetProvider.apply(element);
            Double rotation = this.rotationProvider.apply(element);
            TextWrapperStrategy wrapperStrategy = this.textWrapperStrategyProvider.apply(element);
            HasTitle.Size sizeConstraints = this.sizeConstraintsProvider.apply(element);
            HasTitle.VerticalAlignment verticalAlignment = this.verticalAlignmentProvider.apply(element);
            HasTitle.HorizontalAlignment horizontalAlignment = this.horizontalAlignmentProvider.apply(element);
            HasTitle.ReferencePosition referencePosition = this.referencePositionProvider.apply(element);
            HasTitle.Orientation orientation = this.orientationProvider.apply(element);
            Map<Enum, Double> margins = this.marginsProvider.apply(element);
            if (fontFamily != null && fontFamily.trim().length() > 0) {
                hasTitle.setTitleFontFamily(fontFamily);
            }
            if (fontColor != null && fontColor.trim().length() > 0) {
                hasTitle.setTitleFontColor(fontColor);
            }
            if (strokeColor != null && strokeColor.trim().length() > 0) {
                hasTitle.setTitleStrokeColor(strokeColor);
            }
            if (fontSize != null) {
                hasTitle.setTitleFontSize(fontSize.doubleValue());
            }
            if (strokeSize != null) {
                hasTitle.setTitleStrokeWidth(strokeSize.doubleValue());
            }
            if (strokeAlpha != null) {
                hasTitle.setTitleStrokeAlpha(strokeAlpha.doubleValue());
            }
            if (null != alpha) {
                hasTitle.setTitleAlpha(alpha.doubleValue());
            }
            if (null != positionXOffset) {
                hasTitle.setTitleXOffsetPosition(positionXOffset);
            }
            if (null != positionYOffset) {
                hasTitle.setTitleYOffsetPosition(positionYOffset);
            }
            if (null != rotation) {
                hasTitle.setTitleRotation(rotation.doubleValue());
            }
            if (wrapperStrategy != null) {
                hasTitle.setTextWrapper(wrapperStrategy);
            }
            Optional.ofNullable(margins).ifPresent(m -> this.margins.putAll((Map<Enum, Double>)m));
            if (!this.margins.isEmpty()) {
                hasTitle.setMargins(this.margins);
            }
            if (sizeConstraints != null) {
                hasTitle.setTextSizeConstraints(sizeConstraints);
            }
            this.applyTextPosition(hasTitle, rotation, verticalAlignment, horizontalAlignment, referencePosition, orientation);
        }
    }

    private void applyTextPosition(HasTitle hasTitle, Double rotation, HasTitle.VerticalAlignment verticalAlignment, HasTitle.HorizontalAlignment horizontalAlignment, HasTitle.ReferencePosition referencePosition, HasTitle.Orientation orientation) {
        HasTitle.Orientation currentOrientation = orientation;
        if (rotation != null) {
            switch (rotation.intValue()) {
                case 90: 
                case 270: {
                    currentOrientation = HasTitle.Orientation.VERTICAL;
                    break;
                }
                default: {
                    currentOrientation = HasTitle.Orientation.HORIZONTAL;
                }
            }
        }
        if (Stream.of(verticalAlignment, horizontalAlignment, referencePosition, currentOrientation).allMatch(Objects::nonNull)) {
            hasTitle.setTitlePosition(verticalAlignment, horizontalAlignment, referencePosition, currentOrientation);
        }
    }

    public static class Builder<W, V extends ShapeView> {
        private Function<W, Double> alphaProvider;
        private Function<W, String> fontFamilyProvider;
        private Function<W, String> fontColorProvider;
        private Function<W, Double> fontSizeProvider;
        private Function<W, String> strokeColorProvider;
        private Function<W, Double> strokeSizeProvider;
        private Function<W, Double> strokeAlphaProvider;
        private Function<W, Double> positionXOffsetProvider;
        private Function<W, Double> positionYOffsetProvider;
        private Function<W, Double> rotationProvider;
        private Function<W, TextWrapperStrategy> textWrapperStrategyProvider;
        private Function<W, HasTitle.VerticalAlignment> verticalAlignmentProvider;
        private Function<W, HasTitle.HorizontalAlignment> horizontalAlignmentProvider;
        private Function<W, HasTitle.ReferencePosition> referencePositionProvider;
        private Function<W, HasTitle.Orientation> orientationProvider;
        private Function<W, HasTitle.Size> sizeConstraintsProvider;
        private final Map<Enum, Double> margins = new HashMap<Enum, Double>();
        private Function<W, Map<Enum, Double>> marginsProvider;

        public Builder() {
            this.alphaProvider = value -> null;
            this.fontFamilyProvider = value -> null;
            this.fontColorProvider = value -> null;
            this.fontSizeProvider = value -> null;
            this.strokeColorProvider = value -> null;
            this.strokeSizeProvider = value -> null;
            this.positionXOffsetProvider = value -> null;
            this.positionYOffsetProvider = value -> null;
            this.rotationProvider = value -> null;
            this.strokeAlphaProvider = value -> null;
            this.textWrapperStrategyProvider = value -> null;
            this.verticalAlignmentProvider = value -> null;
            this.horizontalAlignmentProvider = value -> null;
            this.referencePositionProvider = value -> null;
            this.orientationProvider = value -> null;
            this.sizeConstraintsProvider = value -> null;
            this.marginsProvider = value -> null;
        }

        public Builder<W, V> alpha(Function<W, Double> alphaProvider) {
            this.alphaProvider = alphaProvider;
            return this;
        }

        public Builder<W, V> fontFamily(Function<W, String> provider) {
            this.fontFamilyProvider = provider;
            return this;
        }

        public Builder<W, V> fontColor(Function<W, String> provider) {
            this.fontColorProvider = provider;
            return this;
        }

        public Builder<W, V> fontSize(Function<W, Double> provider) {
            this.fontSizeProvider = provider;
            return this;
        }

        public Builder<W, V> strokeColor(Function<W, String> provider) {
            this.strokeColorProvider = provider;
            return this;
        }

        public Builder<W, V> strokeSize(Function<W, Double> provider) {
            this.strokeSizeProvider = provider;
            return this;
        }

        public Builder<W, V> strokeAlpha(Function<W, Double> provider) {
            this.strokeAlphaProvider = provider;
            return this;
        }

        public Builder<W, V> verticalAlignment(Function<W, HasTitle.VerticalAlignment> provider) {
            this.verticalAlignmentProvider = provider;
            return this;
        }

        public Builder<W, V> horizontalAlignment(Function<W, HasTitle.HorizontalAlignment> provider) {
            this.horizontalAlignmentProvider = provider;
            return this;
        }

        public Builder<W, V> referencePosition(Function<W, HasTitle.ReferencePosition> provider) {
            this.referencePositionProvider = provider;
            return this;
        }

        public Builder<W, V> orientation(Function<W, HasTitle.Orientation> provider) {
            this.orientationProvider = provider;
            return this;
        }

        public Builder<W, V> positionXOffset(Function<W, Double> provider) {
            this.positionXOffsetProvider = provider;
            return this;
        }

        public Builder<W, V> positionYOffset(Function<W, Double> provider) {
            this.positionYOffsetProvider = provider;
            return this;
        }

        public Builder<W, V> rotation(Function<W, Double> provider) {
            this.rotationProvider = provider;
            return this;
        }

        public Builder<W, V> textWrapperStrategy(Function<W, TextWrapperStrategy> provider) {
            this.textWrapperStrategyProvider = provider;
            return this;
        }

        public Builder<W, V> textSizeConstraints(Function<W, HasTitle.Size> provider) {
            this.sizeConstraintsProvider = provider;
            return this;
        }

        public Builder<W, V> margin(Enum direction, Double margin) {
            this.margins.put(direction, margin);
            return this;
        }

        public Builder<W, V> margins(Function<W, Map<Enum, Double>> marginsProvider) {
            this.marginsProvider = marginsProvider;
            return this;
        }

        public FontHandler<W, V> build() {
            return new FontHandler(this.alphaProvider, this.fontFamilyProvider, this.fontColorProvider, this.fontSizeProvider, this.strokeColorProvider, this.strokeSizeProvider, this.strokeAlphaProvider, this.positionXOffsetProvider, this.positionYOffsetProvider, this.rotationProvider, this.textWrapperStrategyProvider, this.verticalAlignmentProvider, this.horizontalAlignmentProvider, this.referencePositionProvider, this.orientationProvider, this.sizeConstraintsProvider, this.margins, this.marginsProvider);
        }
    }
}

