/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.util;

import java.util.Collection;
import java.util.Optional;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Node;

public class ClientUtils {
    public static String getSelectedElementUUID(ClientSession clientSession) {
        Optional<Collection> selectedItems = Optional.empty();
        if (clientSession instanceof EditorSession) {
            selectedItems = Optional.ofNullable(((EditorSession)clientSession).getSelectionControl().getSelectedItems());
        } else if (clientSession instanceof ViewerSession) {
            selectedItems = Optional.ofNullable(((ViewerSession)clientSession).getSelectionControl().getSelectedItems());
        }
        return selectedItems.map(strings -> strings.stream().findFirst().orElse(null)).orElse(null);
    }

    public static Node getSelectedNode(Diagram diagram, ClientSession clientSession) {
        String uuid = ClientUtils.getSelectedElementUUID(clientSession);
        return uuid != null ? diagram.getGraph().getNode(uuid) : null;
    }
}

