/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.BoundingBox;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public abstract class AbstractRegistrationCanvasNodeCommand
extends AbstractCanvasCommand {
    private final Node<? extends View<?>, Edge> candidate;
    private final String shapeSetId;

    protected AbstractRegistrationCanvasNodeCommand(Node<? extends View<?>, Edge> candidate, String shapeSetId) {
        this.candidate = candidate;
        this.shapeSetId = shapeSetId;
    }

    protected void register(AbstractCanvasHandler context) {
        context.register(this.shapeSetId, (Element<View<?>>)this.candidate);
        double[] size = GraphUtils.getNodeSize((View)((View)this.candidate.getContent()));
        if (size[0] <= 0.0 || size[1] <= 0.0) {
            Shape shape = context.getCanvas().getShape(this.candidate.getUUID());
            ShapeView shapeView = shape.getShapeView();
            Point2D location = GraphUtils.getPosition((View)((View)this.candidate.getContent()));
            BoundingBox boundingBox = shapeView.getBoundingBox();
            ((View)this.candidate.getContent()).setBounds(Bounds.create((double)location.getX(), (double)location.getY(), (double)(location.getX() + boundingBox.getWidth()), (double)(location.getY() + boundingBox.getHeight())));
        }
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        this.register(context);
        context.applyElementMutation((Element)this.candidate, MutationContext.STATIC);
        return this.buildResult();
    }

    public Node getCandidate() {
        return this.candidate;
    }

    public String getShapeSetId() {
        return this.shapeSetId;
    }
}

