/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.Collection;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveCanvasChildrenCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;

public class SetCanvasChildrenCommand
extends AbstractCanvasCommand {
    private final Node parent;
    private final Collection<Node<?, Edge>> candidates;

    public SetCanvasChildrenCommand(Node parent, Collection<Node<?, Edge>> candidates) {
        this.parent = parent;
        this.candidates = candidates;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        this.candidates.forEach(candidate -> this.setCanvasChild(context, (Node)candidate));
        return this.buildResult();
    }

    private void setCanvasChild(AbstractCanvasHandler context, Node candidate) {
        if (!SetCanvasChildrenCommand.isDocked(candidate)) {
            context.addChild((Element)this.parent, (Element)candidate);
            ShapeUtils.moveViewConnectorsToTop(context, candidate);
        }
    }

    private static boolean isDocked(Node<?, Edge> candidate) {
        return candidate.getInEdges().stream().anyMatch(e -> e.getContent() instanceof Dock);
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new RemoveCanvasChildrenCommand(this.parent, this.candidates).execute(context);
    }

    public Node getParent() {
        return this.parent;
    }

    public Collection<Node<?, Edge>> getCandidates() {
        return this.candidates;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [parent=" + SetCanvasChildrenCommand.toUUID(this.parent) + ",candidates=" + SetCanvasChildrenCommand.toUUIDs(this.candidates) + "]";
    }
}

